/*
 * Decompiled with CFR 0.152.
 */
package test.java.org.akvo.flow.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.akvo.flow.util.FlowJsonObjectReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.waterforpeople.mapping.app.gwt.client.survey.QuestionDto;
import org.waterforpeople.mapping.app.gwt.client.survey.SurveyGroupDto;
import org.waterforpeople.mapping.domain.CaddisflyResource;

class FlowJsonObjectReaderTests {
    private String QUESTION_DTO_JSON_STRING = "{ \"type\": \"FREE_TEXT\",\n\"text\": \"How many toilets are present?\",\n\"dependentFlag\": false,\n\"questionGroupId\": 12345678,\n\"surveyId\": 910111213,\n\"order\": 0 }";
    private String COMPLEX_JSON_OBJECT = "{\n  \"tests\": [\n    {\n      \"name\": \"Soil - Electrical Conductivity\",\n      \"subtype\": \"sensor\",\n      \"uuid\": \"80697cd1-acc9-4a15-8358-f32b4257dfaf\",\n      \"deviceId\": \"SoilEC\",\n      \"brand\": \"Caddisfly\",\n      \"image\": \"Caddisfly-Soil-EC\",\n      \"imageScale\": \"centerCrop\",\n      \"ranges\": \"50,12800\",\n      \"responseFormat\": \"$2,$1\",\n      \"instructions\": [],\n      \"results\": [\n        {\n          \"id\": 1,\n          \"name\": \"Soil Electrical Conductivity\",\n          \"unit\": \"\u03bcS/cm\"\n        },\n        {\n          \"id\": 2,\n          \"name\": \"Temperature\",\n          \"unit\": \"\u00b0Celsius\"\n        }\n      ]\n    },\n    {\n      \"name\": \"Soil - Moisture\",\n      \"subtype\": \"sensor\",\n      \"uuid\": \"0b4a0aaa-f556-4c11-a539-c4626582cca6\",\n      \"deviceId\": \"Soil Moisture\",\n      \"brand\": \"Caddisfly\",\n      \"image\": \"Caddisfly-Soil-Moisture\",\n      \"imageScale\": \"centerCrop\",\n      \"ranges\": \"0,100\",\n      \"responseFormat\": \"$1\",\n      \"instructions\": [],\n      \"results\": [\n        {\n          \"id\": 1,\n          \"name\": \"Soil Moisture\",\n          \"unit\": \"% VWC\"\n        }\n      ]\n    }\n]}";
    private String DTO_LIST_JSON_OBJECT = "{\n  \"code\": null, \n  \"cursor\": null, \n  \"dtoList\": [\n    {\n      \"ancestorIds\": [\n        0, \n        278889175415\n      ], \n      \"code\": \"1.10.36 all questions\", \n      \"createdDateTime\": 1534846914945, \n      \"dataApprovalGroupId\": null, \n      \"defaultLanguageCode\": \"en\", \n      \"description\": \"\", \n      \"keyId\": 2989762914097, \n      \"lastUpdateDateTime\": 1534846926804, \n      \"monitoringGroup\": false, \n      \"name\": \"1.10.36 all questions\", \n      \"newLocaleSurveyId\": null, \n      \"parentId\": 27888911545, \n      \"path\": \"/_1.9.36 and 2.6.0/1.10.36 all questions\", \n      \"privacyLevel\": \"PRIVATE\", \n      \"projectType\": \"PROJECT\", \n      \"published\": false, \n      \"requireDataApproval\": false, \n      \"surveyList\": null\n    }\n  ], \n  \"message\": null, \n  \"offset\": 0, \n  \"resultCount\": 0, \n  \"url\": null\n}\n";

    FlowJsonObjectReaderTests() {
    }

    @Test
    void testReadSimpleJsonObject() {
        FlowJsonObjectReader reader = new FlowJsonObjectReader();
        TypeReference<QuestionDto> typeReference = new TypeReference<QuestionDto>(){};
        QuestionDto testQuestionDto = null;
        try {
            testQuestionDto = reader.readObject(this.QUESTION_DTO_JSON_STRING, typeReference);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)((Object)QuestionDto.QuestionType.FREE_TEXT), (Object)((Object)testQuestionDto.getType()));
        Assertions.assertEquals((Object)"How many toilets are present?", (Object)testQuestionDto.getText());
        Assertions.assertFalse((boolean)testQuestionDto.getDependentFlag());
        Assertions.assertEquals((long)12345678L, (Long)testQuestionDto.getQuestionGroupId());
        Assertions.assertEquals((Object)((Object)QuestionDto.QuestionType.FREE_TEXT), (Object)((Object)testQuestionDto.getType()));
        Assertions.assertEquals((int)0, (Integer)testQuestionDto.getOrder());
    }

    @Test
    void testReadComplexJsonObject() {
        FlowJsonObjectReader reader = new FlowJsonObjectReader();
        TypeReference<Map<String, List<CaddisflyResource>>> typeReference = new TypeReference<Map<String, List<CaddisflyResource>>>(){};
        Map<Object, Object> resourcesMap = new HashMap();
        try {
            resourcesMap = reader.readObject(this.COMPLEX_JSON_OBJECT, typeReference);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        List resourcesList = (List)resourcesMap.get("tests");
        Assertions.assertNotEquals(null, (Object)resourcesList);
        Assertions.assertEquals((int)2, (int)resourcesList.size());
        Assertions.assertEquals((int)2, (int)((CaddisflyResource)resourcesList.get(0)).getResults().size());
        Assertions.assertEquals((Object)"Soil - Electrical Conductivity", (Object)((CaddisflyResource)resourcesList.get(0)).getName());
        Assertions.assertEquals((int)1, (int)((CaddisflyResource)resourcesList.get(1)).getResults().size());
        Assertions.assertEquals((Object)"0b4a0aaa-f556-4c11-a539-c4626582cca6", (Object)((CaddisflyResource)resourcesList.get(1)).getUuid());
    }

    @Test
    void testDtoListResponses() {
        FlowJsonObjectReader reader = new FlowJsonObjectReader();
        TypeReference<SurveyGroupDto> typeReference = new TypeReference<SurveyGroupDto>(){};
        List<SurveyGroupDto> surveyList = null;
        try {
            surveyList = reader.readDtoListObject(this.DTO_LIST_JSON_OBJECT, typeReference);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertNotEquals(null, surveyList);
        Assertions.assertEquals((int)1, (int)surveyList.size());
        Assertions.assertEquals((Object)"1.10.36 all questions", (Object)surveyList.get(0).getName());
    }
}

