/*
 * Decompiled with CFR 0.152.
 */
package org.waterforpeople.mapping.app.web.rest;

import com.gallatinsystems.notification.app.gwt.client.NotificationSubscriptionDto;
import com.gallatinsystems.notification.dao.NotificationSubscriptionDao;
import com.gallatinsystems.notification.domain.NotificationSubscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.waterforpeople.mapping.app.util.DtoMarshaller;
import org.waterforpeople.mapping.app.web.rest.dto.NotificationSubscriptionPayload;
import org.waterforpeople.mapping.app.web.rest.dto.RestStatusDto;

@Controller
@RequestMapping(value={"/notification_subscriptions"})
public class NotificationSubscriptionRestService {
    private NotificationSubscriptionDao notificationSubscriptionDao = new NotificationSubscriptionDao();

    @RequestMapping(method={RequestMethod.GET}, value={"/all"})
    @ResponseBody
    public Map<String, List<NotificationSubscriptionDto>> listNotificationSubscriptions() {
        HashMap<String, List<NotificationSubscriptionDto>> response = new HashMap<String, List<NotificationSubscriptionDto>>();
        ArrayList<NotificationSubscriptionDto> results = new ArrayList<NotificationSubscriptionDto>();
        List notificationSubscriptions = this.notificationSubscriptionDao.list("all");
        if (notificationSubscriptions != null) {
            for (NotificationSubscription s : notificationSubscriptions) {
                NotificationSubscriptionDto dto = new NotificationSubscriptionDto();
                DtoMarshaller.copyToDto(s, dto);
                results.add(dto);
            }
        }
        response.put("notification_subscriptions", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={""})
    @ResponseBody
    public Map<String, List<NotificationSubscriptionDto>> listNotificationSubscriptionBySurvey(@RequestParam(value="surveyId") Long surveyId) {
        HashMap<String, List<NotificationSubscriptionDto>> response = new HashMap<String, List<NotificationSubscriptionDto>>();
        ArrayList<NotificationSubscriptionDto> results = new ArrayList<NotificationSubscriptionDto>();
        List<NotificationSubscription> notificationSubscriptions = this.notificationSubscriptionDao.listSubscriptions(surveyId, null, false);
        if (notificationSubscriptions != null) {
            for (NotificationSubscription s : notificationSubscriptions) {
                NotificationSubscriptionDto dto = new NotificationSubscriptionDto();
                DtoMarshaller.copyToDto(s, dto);
                results.add(dto);
            }
        }
        response.put("notification_subscriptions", results);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Map<String, NotificationSubscriptionDto> findNotificationSubscription(@PathVariable(value="id") Long id) {
        HashMap<String, NotificationSubscriptionDto> response = new HashMap<String, NotificationSubscriptionDto>();
        NotificationSubscription s = (NotificationSubscription)this.notificationSubscriptionDao.getByKey(id);
        NotificationSubscriptionDto dto = null;
        if (s != null) {
            dto = new NotificationSubscriptionDto();
            DtoMarshaller.copyToDto(s, dto);
        }
        response.put("notification_subscription", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Map<String, RestStatusDto> deleteNotificationSubscriptionById(@PathVariable(value="id") Long id) {
        HashMap<String, RestStatusDto> response = new HashMap<String, RestStatusDto>();
        NotificationSubscription s = (NotificationSubscription)this.notificationSubscriptionDao.getByKey(id);
        RestStatusDto statusDto = null;
        statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (s != null) {
            this.notificationSubscriptionDao.delete(s);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        return response;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    @ResponseBody
    public Map<String, Object> saveExistingNotificationSubscription(@RequestBody NotificationSubscriptionPayload payLoad) {
        NotificationSubscription s;
        Long keyId;
        NotificationSubscriptionDto notificationSubscriptionDto = payLoad.getNotification_subscription();
        HashMap<String, Object> response = new HashMap<String, Object>();
        NotificationSubscriptionDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (notificationSubscriptionDto != null && (keyId = notificationSubscriptionDto.getKeyId()) != null && (s = (NotificationSubscription)this.notificationSubscriptionDao.getByKey(keyId)) != null) {
            BeanUtils.copyProperties((Object)notificationSubscriptionDto, (Object)s, (String[])new String[]{"createdDateTime"});
            s = this.notificationSubscriptionDao.save(s);
            dto = new NotificationSubscriptionDto();
            DtoMarshaller.copyToDto(s, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("notification_subscription", dto);
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, value={""})
    @ResponseBody
    public Map<String, Object> saveNewNotificationSubscription(@RequestBody NotificationSubscriptionPayload payLoad) {
        NotificationSubscriptionDto notificationSubscriptionDto = payLoad.getNotification_subscription();
        HashMap<String, Object> response = new HashMap<String, Object>();
        NotificationSubscriptionDto dto = null;
        RestStatusDto statusDto = new RestStatusDto();
        statusDto.setStatus("failed");
        if (notificationSubscriptionDto != null) {
            NotificationSubscription s = new NotificationSubscription();
            BeanUtils.copyProperties((Object)notificationSubscriptionDto, (Object)s, (String[])new String[]{"createdDateTime"});
            s = this.notificationSubscriptionDao.save(s);
            dto = new NotificationSubscriptionDto();
            DtoMarshaller.copyToDto(s, dto);
            statusDto.setStatus("ok");
        }
        response.put("meta", statusDto);
        response.put("notification_subscription", dto);
        return response;
    }
}

