/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.security.oidc;

import com.auth0.AuthenticationController;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.rest.security.oidc.AppConfig;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class EntryPoint
implements AuthenticationEntryPoint {
    private static final Logger logger = Logger.getLogger(EntryPoint.class.getName());
    private final AppConfig appConfig;
    private final AuthenticationController controller;
    final Set<String> enabledLocales = new HashSet<String>(Arrays.asList("en", "es", "fr", "pt", "id", "vi"));

    public EntryPoint(AppConfig appConfig) {
        this.appConfig = appConfig;
        this.controller = this.appConfig.authenticationController();
    }

    private boolean isAllowedLocale(String locale) {
        return this.enabledLocales.contains(locale);
    }

    private String getLocale(String reqPararameter) {
        if (this.isAllowedLocale(reqPararameter)) {
            return reqPararameter;
        }
        return "en";
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        String locale = this.getLocale(request.getParameter("locale"));
        logger.fine("Performing login. Locale: " + locale);
        String redirectUri = request.getScheme() + "://" + request.getServerName();
        if (request.getScheme().equals("http") && request.getServerPort() != 80 || request.getScheme().equals("https") && request.getServerPort() != 443) {
            redirectUri = redirectUri + ":" + request.getServerPort();
        }
        redirectUri = redirectUri + "/callback";
        String authorizeUrl = this.controller.buildAuthorizeUrl(request, redirectUri).withAudience(String.format("https://%s/userinfo", this.appConfig.getDomain())).withScope("openid profile email").withParameter("prompt", "select_account").withParameter("ui_locales", locale).build();
        response.sendRedirect(response.encodeRedirectURL(authorizeUrl));
    }
}

