/*
 * Decompiled with CFR 0.152.
 */
package org.akvo.flow.rest.security.oidc;

import com.auth0.AuthenticationController;
import com.auth0.IdentityVerificationException;
import com.auth0.Tokens;
import com.auth0.jwt.JWT;
import com.gallatinsystems.user.dao.UserDao;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akvo.flow.rest.security.google.GoogleAccountsAuthenticationProvider;
import org.akvo.flow.rest.security.oidc.AppConfig;
import org.akvo.flow.rest.security.oidc.TokenAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CallbackController {
    private static final Logger log = Logger.getLogger(CallbackController.class.getName());
    private final AuthenticationController controller;
    private final String redirectOnFail;
    private final String redirectOnSuccess;

    public CallbackController(AppConfig appConfig) {
        this.controller = appConfig.authenticationController();
        this.redirectOnFail = "/auth0/auth0.html";
        this.redirectOnSuccess = "/admin";
    }

    @RequestMapping(value={"/callback"}, method={RequestMethod.GET})
    protected void getCallback(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handle(req, res);
    }

    @RequestMapping(value={"/callback"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    protected void postCallback(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handle(req, res);
    }

    private void handle(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            Tokens tokens = this.controller.handle(req);
            TokenAuthentication tokenAuth = new TokenAuthentication(JWT.decode((String)tokens.getIdToken()));
            Authentication authentication = GoogleAccountsAuthenticationProvider.getAuthentication(false, new UserDao(), (Authentication)tokenAuth, tokenAuth.getClaims().get("email").asString(), tokenAuth.getClaims().get("nickname").asString());
            SecurityContextHolder.getContext().setAuthentication(authentication);
            res.sendRedirect(this.redirectOnSuccess);
        }
        catch (IdentityVerificationException | AuthenticationException e) {
            String errorDescriptionId = "error_description";
            String errorDescription = req.getParameter(errorDescriptionId);
            log.log(Level.SEVERE, errorDescriptionId + ": " + errorDescription + " Error Message: " + e.getMessage());
            SecurityContextHolder.clearContext();
            if (errorDescription != null) {
                res.sendRedirect(this.redirectOnFail + "?errorCode=" + errorDescription);
            }
            res.sendRedirect(this.redirectOnFail);
        }
    }
}

