/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.impl.file.LeastRecentlyUsedCache;
import edu.smu.tspell.wordnet.impl.file.ParseException;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SynsetParser;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.SynsetReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class SynsetFactory {
    private static final int DEFAULT_CACHE_SIZE = 500;
    private static int cacheSize = 500;
    private static SynsetFactory instance;
    private Map pointerSynsets = new WeakHashMap();
    private Map synsetPointers = new WeakHashMap();
    private LeastRecentlyUsedCache cache = new LeastRecentlyUsedCache(cacheSize);

    public static synchronized SynsetFactory getInstance() {
        if (instance == null) {
            instance = new SynsetFactory();
        }
        return instance;
    }

    private SynsetFactory() {
    }

    public synchronized Synset getSynset(SynsetPointer synsetPointer) throws WordNetException {
        Synset synset = this.getCachedSynset(synsetPointer);
        if (synset == null) {
            synset = this.readSynset(synsetPointer);
            this.addToCache(synset, synsetPointer);
            this.cache.put(synsetPointer, synset);
        }
        return synset;
    }

    private Synset getCachedSynset(SynsetPointer synsetPointer) {
        WeakReference weakReference = (WeakReference)this.pointerSynsets.get(synsetPointer);
        return weakReference != null ? (Synset)weakReference.get() : null;
    }

    private void addToCache(Synset synset, SynsetPointer synsetPointer) {
        this.pointerSynsets.put(synsetPointer, new WeakReference<Synset>(synset));
        this.synsetPointers.put(synset, synsetPointer);
    }

    private Synset readSynset(SynsetPointer synsetPointer) throws RetrievalException, ParseException {
        Synset synset;
        String string = null;
        try {
            SynsetReader synsetReader = SynsetReader.getInstance(synsetPointer.getType());
            string = synsetReader.readData(synsetPointer);
            SynsetParser synsetParser = new SynsetParser();
            synset = synsetParser.createSynset(string);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (IOException iOException) {
            throw new RetrievalException("An error occurred reading the synset data", iOException);
        }
        catch (Exception exception) {
            throw new ParseException("An error occurred parsing the synset data: " + string, exception);
        }
        return synset;
    }

    static {
        String string = "wordnet.cache.synsets";
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                cacheSize = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("'" + string2 + "' is an invalid " + "value for " + string + " and will be ignored.");
            }
        }
    }
}

