/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.ExampleSentences;
import edu.smu.tspell.wordnet.impl.file.ParseException;
import edu.smu.tspell.wordnet.impl.file.ReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.SampleFrameFactory;
import edu.smu.tspell.wordnet.impl.file.SampleIndexFactory;
import edu.smu.tspell.wordnet.impl.file.SampleTemplateFactory;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.SynsetTypeConverter;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import edu.smu.tspell.wordnet.impl.file.WordPositions;
import edu.smu.tspell.wordnet.impl.file.WordSensePointer;
import edu.smu.tspell.wordnet.impl.file.synset.AdjectiveReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.AdjectiveSatelliteReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.AdverbReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.NounReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.synset.VerbReferenceSynset;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SynsetParser {
    private static final String FIELD_DELIMITER = " ";
    private static final String FRAME_TERMINATOR = "|";
    private static final String FRAME_HEADER = "+";
    private static final String GLOSS_DELIMITERS = "; ";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String MARKER_START = "(";
    private static final String MARKER_END = ")";
    private static final int HEX = 16;

    public Synset createSynset(String string) {
        ReferenceSynset referenceSynset;
        int n;
        int n2;
        String string2;
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_DELIMITER);
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        char c = stringTokenizer.nextToken().charAt(0);
        SynsetType synsetType = SynsetTypeConverter.getType(c);
        int n6 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        SenseKey[] senseKeyArray = new SenseKey[n6];
        SampleIndexFactory sampleIndexFactory = SampleIndexFactory.getInstance();
        SampleTemplateFactory sampleTemplateFactory = SampleTemplateFactory.getInstance();
        ExampleSentences exampleSentences = new ExampleSentences();
        WordPositions wordPositions = null;
        for (n3 = 0; n3 < n6; ++n3) {
            string2 = TextTranslator.translateToExternalFormat(stringTokenizer.nextToken());
            int n7 = string2.indexOf(MARKER_START);
            if (n7 != -1) {
                int n8 = string2.indexOf(MARKER_END, n7);
                if (n8 == -1) {
                    throw new ParseException("Marker start embedded in form '" + string2 + "' but no marker end text found.");
                }
                String string3 = string2.substring(n7 + 1, n8);
                string2 = string2.substring(0, n7);
                if (wordPositions == null) {
                    wordPositions = new WordPositions();
                }
                wordPositions.setPosition(string2, string3);
            }
            int n9 = Integer.parseInt(stringTokenizer.nextToken(), 16);
            senseKeyArray[n3] = new SenseKey(string2, synsetType, n5, n9);
            String[] stringArray = sampleIndexFactory.getSampleKeys(senseKeyArray[n3]);
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = sampleTemplateFactory.getSample(synsetType, stringArray[i]);
            }
            exampleSentences.setTemplates(senseKeyArray[n3].getLemma(), stringArray2);
        }
        n3 = Integer.parseInt(stringTokenizer.nextToken());
        RelationshipPointers relationshipPointers = new RelationshipPointers();
        for (n2 = 0; n2 < n3; ++n2) {
            RelationshipType relationshipType = RelationshipType.getRelationshipType(stringTokenizer.nextToken());
            int n10 = Integer.parseInt(stringTokenizer.nextToken());
            char c2 = stringTokenizer.nextToken().charAt(0);
            SynsetType synsetType2 = SynsetTypeConverter.getType(c2);
            String string4 = stringTokenizer.nextToken();
            n = Integer.parseInt(string4.substring(0, 2), 16);
            int n11 = Integer.parseInt(string4.substring(2, 4), 16);
            if (n == 0 && n11 == 0) {
                SynsetPointer synsetPointer = new SynsetPointer(synsetType2, n10);
                relationshipPointers.addSemanticRelationship(relationshipType, synsetPointer);
                continue;
            }
            string2 = senseKeyArray[n - 1].getLemma();
            WordSensePointer wordSensePointer = new WordSensePointer(synsetType2, n10, n11);
            relationshipPointers.addLexicalRelationship(string2, relationshipType, wordSensePointer);
        }
        String string5 = stringTokenizer.nextToken();
        if (!string5.equals(FRAME_TERMINATOR)) {
            n2 = Integer.parseInt(string5);
            SampleFrameFactory sampleFrameFactory = SampleFrameFactory.getInstance();
            for (int i = 0; i < n2; ++i) {
                string5 = stringTokenizer.nextToken();
                if (!string5.equals(FRAME_HEADER)) {
                    throw new ParseException("Expected frame header text '+' but found '" + string5 + "' instead: " + string);
                }
                string5 = stringTokenizer.nextToken();
                String string6 = sampleFrameFactory.getSample(synsetType, string5);
                n = Integer.parseInt(stringTokenizer.nextToken(), 16);
                if (n == 0) {
                    exampleSentences.addCommonFrame(string6);
                    continue;
                }
                string2 = senseKeyArray[n - 1].getLemma();
                exampleSentences.addFrame(string6, string2);
            }
            string5 = stringTokenizer.nextToken();
        }
        if (!string5.equals(FRAME_TERMINATOR)) {
            throw new ParseException("Expected frame terminator text '|' but found '" + string5 + "' instead: " + string);
        }
        String string7 = " | ";
        int n12 = string.indexOf(string7);
        String string8 = string.substring(n12 + string7.length());
        GlossContent glossContent = this.parseGloss(string8);
        String string9 = glossContent.getDefinition();
        String[] stringArray = glossContent.getExamples();
        switch (c) {
            case 'n': {
                referenceSynset = new NounReferenceSynset(string9, stringArray, senseKeyArray, relationshipPointers, n5, n4);
                break;
            }
            case 'v': {
                referenceSynset = new VerbReferenceSynset(string9, stringArray, senseKeyArray, relationshipPointers, exampleSentences, n5, n4);
                break;
            }
            case 'a': {
                referenceSynset = new AdjectiveReferenceSynset(string9, stringArray, senseKeyArray, relationshipPointers, n5, n4, wordPositions);
                break;
            }
            case 'r': {
                referenceSynset = new AdverbReferenceSynset(string9, stringArray, senseKeyArray, relationshipPointers, n5, n4);
                break;
            }
            case 's': {
                referenceSynset = new AdjectiveSatelliteReferenceSynset(string9, stringArray, senseKeyArray, relationshipPointers, n5, n4, wordPositions);
                break;
            }
            default: {
                throw new ParseException("The synset type code '" + c + "' is invalid");
            }
        }
        return referenceSynset;
    }

    private GlossContent parseGloss(String string) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        if (stringBuffer.length() > 0) {
            int n;
            if (!DOUBLE_QUOTE.equals(stringBuffer.substring(0, 1))) {
                int n2;
                n = stringBuffer.indexOf(DOUBLE_QUOTE);
                if (n == -1) {
                    n = stringBuffer.length();
                }
                for (n2 = n - 1; n2 >= 0 && GLOSS_DELIMITERS.indexOf(stringBuffer.charAt(n2)) != -1; --n2) {
                }
                string2 = stringBuffer.substring(0, n2 + 1);
                stringBuffer.delete(0, n);
            }
            while (stringBuffer.length() > 0) {
                String string3;
                n = stringBuffer.indexOf(DOUBLE_QUOTE, 1);
                if (n == -1) {
                    n = stringBuffer.length() - 1;
                }
                if ((string3 = stringBuffer.substring(0, n + 1)).length() > 0) {
                    arrayList.add(stringBuffer.substring(0, n + 1));
                }
                stringBuffer.delete(0, n + 1);
                while (stringBuffer.length() > 0 && GLOSS_DELIMITERS.indexOf(stringBuffer.charAt(0)) != -1) {
                    stringBuffer.delete(0, 1);
                }
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return new GlossContent(string2, stringArray);
    }

    private static class GlossContent {
        private String definition;
        private String[] examples;

        public GlossContent(String string, String[] stringArray) {
            this.definition = string;
            this.examples = stringArray;
        }

        public String getDefinition() {
            return this.definition;
        }

        public String[] getExamples() {
            return this.examples;
        }
    }
}

