/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file.synset;

import edu.smu.tspell.wordnet.AdjectiveSatelliteSynset;
import edu.smu.tspell.wordnet.AdjectiveSynset;
import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexReader;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetFactory;
import edu.smu.tspell.wordnet.impl.file.WordPositions;
import edu.smu.tspell.wordnet.impl.file.synset.AdjectiveReferenceSynset;

public class AdjectiveSatelliteReferenceSynset
extends AdjectiveReferenceSynset
implements AdjectiveSatelliteSynset {
    private AdjectiveSynset headSynset;

    public AdjectiveSatelliteReferenceSynset(String string, String[] stringArray, SenseKey[] senseKeyArray, RelationshipPointers relationshipPointers, int n, int n2, WordPositions wordPositions) {
        super(SynsetType.ADJECTIVE_SATELLITE, string, stringArray, senseKeyArray, relationshipPointers, n, n2, wordPositions);
    }

    public synchronized AdjectiveSynset getHeadSynset() throws WordNetException {
        if (this.headSynset == null) {
            this.headSynset = this.retrieveHeadSynset();
        }
        return this.headSynset;
    }

    private AdjectiveSynset retrieveHeadSynset() {
        SenseKey senseKey;
        Synset synset = null;
        SenseKey senseKey2 = this.getSenseKey(0);
        SenseIndexEntry senseIndexEntry = this.getIndexEntry(senseKey2);
        if (senseIndexEntry != null && (senseKey = senseIndexEntry.getSenseKey().getHeadWord()) != null) {
            SenseIndexReader senseIndexReader = SenseIndexReader.getInstance();
            senseIndexEntry = senseIndexReader.getEntry(senseKey.getFullSenseKeyText());
            if (senseIndexEntry != null) {
                SynsetFactory synsetFactory = SynsetFactory.getInstance();
                synset = synsetFactory.getSynset(senseIndexEntry.getSynsetPointer());
            } else {
                throw new RetrievalException("Unable to locate head word entry for " + senseKey + " referenced by " + this);
            }
        }
        return (AdjectiveSynset)synset;
    }

    public boolean isHeadSynset() throws WordNetException {
        return false;
    }
}

