# either-clj [![Build Status](https://travis-ci.org/amitayh/either-clj.svg?branch=master)](https://travis-ci.org/amitayh/either-clj) [![codecov](https://codecov.io/gh/amitayh/either-clj/branch/master/graph/badge.svg)](https://codecov.io/gh/amitayh/either-clj)

Simple error handling for Clojure. Representing success/failure value (disjoint union)
by a 2 elements vector - where the first value is the result (`nil` if failed), and the second
value is the error (`nil` if successful). Plus, the library provides a few useful utilities for
working with these values.

## Getting started

### Installation

### Basic usage

```clojure
(require '[org.amitayh.either :refer :all])

(defn div [a b]
  (if (zero? b)
    (failure :division-by-zero)
    (success (/ a b))))

(div 1 2) ; Returns [1/2 nil]
(div 1 0) ; Returns [nil :division-by-zero]
```

## License

Copyright © 2018 Amitay Horwitz

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
