/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.NotImplementedException;

public class LocalByPartionerType<T extends Token>
extends AbstractType<ByteBuffer> {
    private final IPartitioner<T> partitioner;

    public LocalByPartionerType(IPartitioner<T> partitioner) {
        this.partitioner = partitioner;
    }

    @Override
    public ByteBuffer compose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public ByteBuffer decompose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        throw new NotImplementedException();
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return RowPosition.forKey(o1, this.partitioner).compareTo(RowPosition.forKey(o2, this.partitioner));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        throw new IllegalStateException("You shouldn't be validating this.");
    }
}

