/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.cassandra.db.AtomicSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.util.ColumnSortedMap;
import org.apache.cassandra.utils.ByteBufferUtil;

class SuperColumnSerializer
implements IColumnSerializer {
    private final AbstractType<?> comparator;

    public SuperColumnSerializer(AbstractType<?> comparator) {
        this.comparator = comparator;
    }

    public AbstractType<?> getComparator() {
        return this.comparator;
    }

    @Override
    public void serialize(IColumn column, DataOutput dos) throws IOException {
        SuperColumn superColumn = (SuperColumn)column;
        ByteBufferUtil.writeWithShortLength(superColumn.name(), dos);
        DeletionInfo.serializer().serialize(superColumn.deletionInfo(), dos, 3);
        Collection<IColumn> columns = superColumn.getSubColumns();
        dos.writeInt(columns.size());
        for (IColumn subColumn : columns) {
            Column.serializer().serialize(subColumn, dos);
        }
    }

    @Override
    public IColumn deserialize(DataInput dis) throws IOException {
        return this.deserialize(dis, IColumnSerializer.Flag.LOCAL);
    }

    public IColumn deserialize(DataInput dis, IColumnSerializer.Flag flag) throws IOException {
        return this.deserialize(dis, flag, (int)(System.currentTimeMillis() / 1000L));
    }

    @Override
    public IColumn deserialize(DataInput dis, IColumnSerializer.Flag flag, int expireBefore) throws IOException {
        ByteBuffer name = ByteBufferUtil.readWithShortLength(dis);
        DeletionInfo delInfo = DeletionInfo.serializer().deserialize(dis, 3, this.comparator);
        int size = dis.readInt();
        ColumnSerializer serializer = Column.serializer();
        ColumnSortedMap preSortedMap = new ColumnSortedMap(this.comparator, serializer, dis, size, flag, expireBefore);
        SuperColumn superColumn = new SuperColumn(name, AtomicSortedColumns.factory().fromSorted(preSortedMap, false));
        superColumn.delete(delInfo);
        return superColumn;
    }

    @Override
    public long serializedSize(IColumn object, TypeSizes typeSizes) {
        return object.serializedSize(typeSizes);
    }
}

