/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.deltacloud.client.Action;
import org.apache.deltacloud.client.DeltaCloudClient;
import org.apache.deltacloud.client.DeltaCloudClientException;
import org.apache.deltacloud.client.IdAware;

public abstract class ActionAware<OWNER>
extends IdAware {
    private List<Action<OWNER>> actions;

    public Action<OWNER> getAction(String name) {
        if (name == null) {
            return null;
        }
        for (Action<OWNER> action : this.getActions()) {
            if (!name.equals(action.getName())) continue;
            return action;
        }
        return null;
    }

    public List<String> getActionNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Action<OWNER> action : this.getActions()) {
            names.add(action.getName());
        }
        return names;
    }

    public boolean start(DeltaCloudClient client) throws DeltaCloudClientException {
        InputStream in = client.performAction(this.getAction("start"));
        this.update(in);
        return in != null;
    }

    public boolean stop(DeltaCloudClient client) throws DeltaCloudClientException {
        InputStream in = client.performAction(this.getAction("stop"));
        this.update(in);
        return in != null;
    }

    public boolean destroy(DeltaCloudClient client) throws DeltaCloudClientException {
        InputStream in = client.performAction(this.getAction("destroy"));
        return in != null;
    }

    public boolean reboot(DeltaCloudClient client) throws DeltaCloudClientException {
        InputStream in = client.performAction(this.getAction("reboot"));
        this.update(in);
        return in != null;
    }

    protected void update(InputStream in) throws DeltaCloudClientException {
        if (in == null) {
            return;
        }
        this.doUpdate(in);
    }

    protected abstract void doUpdate(InputStream var1) throws DeltaCloudClientException;

    public boolean canStart() {
        return this.getAction("start") != null;
    }

    public boolean canStop() {
        return this.getAction("stop") != null;
    }

    public boolean canReboot() {
        return this.getAction("reboot") != null;
    }

    public boolean canDestroy() {
        return this.getAction("destroy") != null;
    }

    public void setActions(List<Action<OWNER>> actions) {
        this.actions = actions;
    }

    public List<Action<OWNER>> getActions() {
        return this.actions;
    }
}

