/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client;

import java.util.List;
import org.apache.deltacloud.client.IdAware;

public class Property
extends IdAware {
    private static final long serialVersionUID = 1L;
    private String kind;
    private String unit;
    private String name;
    private String value;
    private String first;
    private String last;
    private List<String> enums;

    public String getKind() {
        return this.kind;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Range getRange() {
        return new Range(this.first, this.last);
    }

    public List<String> getEnums() {
        return this.enums;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setRange(String first, String last) {
        this.first = first;
        this.last = last;
    }

    public void setEnums(List<String> enums) {
        this.enums = enums;
    }

    @Override
    public String toString() {
        if (this.kind.equals("range")) {
            return this.first + '-' + this.last + "(default: " + this.value + ")";
        }
        if (this.kind.equals("enum")) {
            String s = this.enums.get(0);
            for (int i = 1; i < this.enums.size(); ++i) {
                s = s + ", " + this.enums.get(i);
            }
            s = s + " (default:" + this.value + ")";
            return s;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        if (!UNIT.LABEL.matches(this.unit)) {
            builder.append(' ').append(this.unit);
        }
        return builder.toString();
    }

    public class Range {
        private String first;
        private String last;

        public Range(String first, String last) {
            this.first = first;
            this.last = last;
        }

        public String getFirst() {
            return this.first;
        }

        public String getLast() {
            return this.last;
        }
    }

    public static enum UNIT {
        MB{

            @Override
            public boolean matches(String value) {
                return this.name().equals(value);
            }
        }
        ,
        GB{

            @Override
            public boolean matches(String value) {
                return this.name().equals(value);
            }
        }
        ,
        LABEL{

            @Override
            public boolean matches(String value) {
                return this.name().toLowerCase().equals(value);
            }
        }
        ,
        COUNT{

            @Override
            public boolean matches(String value) {
                return this.name().toLowerCase().equals(value);
            }
        };


        public abstract boolean matches(String var1);
    }

    public static enum Names {
        MEMORY,
        STORAGE,
        CPU,
        ARCHITECTURE;

    }

    public static enum Kind {
        FIXED,
        RANGE,
        ENUM;

    }
}

