/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client.transport;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.deltacloud.client.DeltaCloudAuthClientException;
import org.apache.deltacloud.client.DeltaCloudClientException;
import org.apache.deltacloud.client.DeltaCloudNotFoundClientException;
import org.apache.deltacloud.client.HttpStatusCode;
import org.apache.deltacloud.client.HttpStatusRange;
import org.apache.deltacloud.client.request.DeltaCloudRequest;
import org.apache.deltacloud.client.transport.IHttpTransport;

public abstract class AbstractHttpTransport
implements IHttpTransport {
    private String username;
    private String password;

    public AbstractHttpTransport(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public final InputStream request(DeltaCloudRequest request) throws DeltaCloudClientException {
        try {
            return this.doRequest(request);
        }
        catch (MalformedURLException e) {
            throw new DeltaCloudClientException(MessageFormat.format("Could not connect to \"{0}\". The url is invalid.", request.getUrlString()), e);
        }
        catch (DeltaCloudClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeltaCloudClientException(e);
        }
    }

    protected abstract InputStream doRequest(DeltaCloudRequest var1) throws Exception;

    protected void throwOnHttpErrors(int statusCode, String statusMessage, URL requestUrl) throws DeltaCloudClientException {
        if (HttpStatusCode.OK.isStatus(statusCode)) {
            return;
        }
        if (HttpStatusCode.UNAUTHORIZED.isStatus(statusCode)) {
            throw new DeltaCloudAuthClientException(MessageFormat.format("The server reported an authorization error \"{0}\" on requesting \"{1}\"", statusMessage, requestUrl));
        }
        if (HttpStatusCode.NOT_FOUND.isStatus(statusCode)) {
            throw new DeltaCloudNotFoundClientException(MessageFormat.format("The server could not find the resource \"{0}\"", requestUrl));
        }
        if (HttpStatusRange.CLIENT_ERROR.isInRange(statusCode) || HttpStatusRange.SERVER_ERROR.isInRange(statusCode)) {
            throw new DeltaCloudClientException(MessageFormat.format("The server reported an error \"{0}\" on requesting \"{1}\"", statusMessage, requestUrl));
        }
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }
}

