/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client.unmarshal;

import java.util.ArrayList;
import java.util.List;
import org.apache.deltacloud.client.HardwareProfile;
import org.apache.deltacloud.client.Property;
import org.apache.deltacloud.client.unmarshal.AbstractDOMUnmarshaller;
import org.apache.deltacloud.client.utils.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HardwareProfileUnmarshaller
extends AbstractDOMUnmarshaller<HardwareProfile> {
    public HardwareProfileUnmarshaller() {
        super("hardware_profile", HardwareProfile.class);
    }

    @Override
    protected HardwareProfile doUnmarshall(Element element, HardwareProfile profile) throws Exception {
        profile.setId(this.getAttributeText("id", element));
        profile.setProperties(this.createProperties(element.getElementsByTagName("property")));
        return profile;
    }

    private List<Property> createProperties(NodeList propertiesList) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int i = 0; i < propertiesList.getLength(); ++i) {
            Property property = this.createProperty(propertiesList.item(i));
            properties.add(property);
        }
        return properties;
    }

    private Property createProperty(Node node) {
        Assert.isTrue(node instanceof Element);
        Element element = (Element)node;
        Property property = new Property();
        property.setName(element.getAttribute("name"));
        property.setId(element.getAttribute("id"));
        property.setUnit(element.getAttribute("unit"));
        property.setValue(element.getAttribute("value"));
        String kind = element.getAttribute("kind");
        Assert.isTrue(kind != null);
        kind = kind.toUpperCase();
        property.setKind(kind);
        if (Property.Kind.RANGE.toString().equals(property.getKind())) {
            this.setRange(element, property);
        } else if (Property.Kind.ENUM.toString().equals(property.getKind())) {
            this.setEnum(element, property);
        } else if (Property.Kind.FIXED.toString().equals(property.getKind())) {
            // empty if block
        }
        return property;
    }

    private void setRange(Element propertyElement, Property property) {
        Node node = propertyElement.getElementsByTagName("range").item(0);
        Assert.isTrue(node instanceof Element);
        Element rangeElement = (Element)node;
        property.setRange(rangeElement.getAttribute("first"), rangeElement.getAttribute("last"));
    }

    private void setEnum(Element propertyElement, Property property) {
        Node node = propertyElement.getElementsByTagName("enum").item(0);
        Assert.isTrue(node instanceof Element);
        Element enumElement = (Element)node;
        NodeList nodeList = enumElement.getElementsByTagName("entry");
        ArrayList<String> enumValues = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node entryNode = nodeList.item(i);
            Assert.isTrue(entryNode instanceof Element);
            Element entryElement = (Element)entryNode;
            enumValues.add(entryElement.getAttribute("value"));
        }
        property.setEnums(enumValues);
    }
}

