/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client.unmarshal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.deltacloud.client.Action;
import org.apache.deltacloud.client.DeltaCloudClientException;
import org.apache.deltacloud.client.Key;
import org.apache.deltacloud.client.unmarshal.AbstractActionAwareUnmarshaller;
import org.apache.deltacloud.client.unmarshal.ActionUnmarshaller;
import org.w3c.dom.Element;

public class KeyUnmarshaller
extends AbstractActionAwareUnmarshaller<Key> {
    public KeyUnmarshaller() {
        super("key", Key.class, "link");
    }

    @Override
    protected Key doUnmarshall(Element element, Key key) throws Exception {
        if (element != null) {
            key.setId(this.getAttributeText("id", element));
            key.setUrl(this.getAttributeText("href", element));
            key.setState(this.getFirstElementText("state", element));
            key.setFingerprint(this.getFirstElementText("fingerprint", element));
            key.setPem(this.trimPem(this.getPem(element)));
            key.setActions(this.getActions(element, key));
        }
        return key;
    }

    private String getPem(Element element) {
        Element pemElement = this.getFirstElement("pem", element);
        if (pemElement != null) {
            return this.getFirstElementText("pem", pemElement);
        }
        return null;
    }

    private String trimPem(String pem) throws IOException {
        if (pem == null || pem.length() <= 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String line = null;
        BufferedReader reader = new BufferedReader(new StringReader(pem));
        while ((line = reader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.length() <= 0) continue;
            sb.append(trimmedLine).append('\n');
        }
        return sb.toString();
    }

    @Override
    protected Action<Key> unmarshallAction(Element element) throws DeltaCloudClientException {
        Action<Key> keyAction = new Action<Key>();
        new ActionUnmarshaller().unmarshall(element, keyAction);
        return keyAction;
    }
}

