/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltacloud.client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

public class StringUtils {
    public static <E> String getFormattedString(Collection<E> elements, IElementFormatter<E> elementFormatter) {
        StringBuilder builder = new StringBuilder();
        for (E element : elements) {
            String formattedElement = elementFormatter.format(element);
            if (formattedElement == null || formattedElement.length() <= 0) continue;
            builder.append(formattedElement);
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return "";
    }

    public static <E> Collection<String> getFormattedStrings(Collection<E> elements, IElementFormatter<E> elementFormatter) {
        ArrayList<String> strings = new ArrayList<String>();
        for (E element : elements) {
            String formattedElement = elementFormatter.format(element);
            if (formattedElement == null || formattedElement.length() <= 0) continue;
            strings.add(formattedElement);
        }
        return strings;
    }

    public static String null2EmptyString(String stringValue) {
        if (stringValue == null) {
            return "";
        }
        return stringValue;
    }

    public static String emptyString2Null(String stringValue) {
        if (stringValue != null && stringValue.length() == 0) {
            return null;
        }
        return stringValue;
    }

    public static boolean isEmpty(String stringValue) {
        return stringValue == null || stringValue.isEmpty();
    }

    public static String toString(InputStream inputStream) throws IOException {
        StringBuilder builder = new StringBuilder();
        int character = -1;
        while ((character = inputStream.read()) != -1) {
            builder.append((char)character);
        }
        return builder.toString();
    }

    public static interface IElementFormatter<E> {
        public String format(E var1);
    }
}

