/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDependent;

public final class taskdetailshistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static List _jspx_dependants;

    private void printTaskAttempt(JobHistory.TaskAttempt taskAttempt, String type, JspWriter out) throws IOException {
        out.print("<tr>");
        out.print("<td>" + taskAttempt.get(JobHistory.Keys.TASK_ATTEMPT_ID) + "</td>");
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, taskAttempt.getLong(JobHistory.Keys.START_TIME), 0L) + "</td>");
        if (JobHistory.Values.REDUCE.name().equals(type)) {
            JobHistory.ReduceAttempt reduceAttempt = (JobHistory.ReduceAttempt)taskAttempt;
            out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, reduceAttempt.getLong(JobHistory.Keys.SHUFFLE_FINISHED), reduceAttempt.getLong(JobHistory.Keys.START_TIME)) + "</td>");
            out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, reduceAttempt.getLong(JobHistory.Keys.SORT_FINISHED), reduceAttempt.getLong(JobHistory.Keys.SHUFFLE_FINISHED)) + "</td>");
        }
        out.print("<td>" + StringUtils.getFormattedTimeWithDiff(dateFormat, taskAttempt.getLong(JobHistory.Keys.FINISH_TIME), taskAttempt.getLong(JobHistory.Keys.START_TIME)) + "</td>");
        out.print("<td>" + taskAttempt.get(JobHistory.Keys.HOSTNAME) + "</td>");
        out.print("<td>" + taskAttempt.get(JobHistory.Keys.ERROR) + "</td>");
        out.print("<td>");
        String taskLogsUrl = JobHistory.getTaskLogsUrl(taskAttempt);
        if (taskLogsUrl != null) {
            String tailFourKBUrl = taskLogsUrl + "&start=-4097";
            String tailEightKBUrl = taskLogsUrl + "&start=-8193";
            String entireLogUrl = taskLogsUrl + "&all=true";
            out.print("<a href=\"" + tailFourKBUrl + "\">Last 4KB</a><br/>");
            out.print("<a href=\"" + tailEightKBUrl + "\">Last 8KB</a><br/>");
            out.print("<a href=\"" + entireLogUrl + "\">All</a><br/>");
        } else {
            out.print("n/a");
        }
        out.print("</td>");
        out.print("</tr>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        taskdetailshistory_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)("loadhistory.jsp" + ("loadhistory.jsp".indexOf(63) > 0 ? (char)'&' : '?') + JspRuntimeLibrary.URLEncode((String)"jobid", (String)request.getCharacterEncoding()) + "=" + JspRuntimeLibrary.URLEncode((String)String.valueOf(request.getParameter("jobid")), (String)request.getCharacterEncoding()) + "&" + JspRuntimeLibrary.URLEncode((String)"jobTrackerId", (String)request.getCharacterEncoding()) + "=" + JspRuntimeLibrary.URLEncode((String)String.valueOf(request.getParameter("jobTrackerId")), (String)request.getCharacterEncoding())), (JspWriter)out, (boolean)false);
            out.write(10);
            out.write(10);
            out.write(10);
            String jobid = request.getParameter("jobid");
            String logFile = request.getParameter("logFile");
            String encodedLogFileName = JobHistory.JobInfo.encodeJobHistoryFilePath(logFile);
            String taskid = request.getParameter("taskid");
            JobHistory.JobInfo job = (JobHistory.JobInfo)request.getSession().getAttribute("job");
            JobHistory.Task task = job.getAllTasks().get(taskid);
            String type = task.get(JobHistory.Keys.TASK_TYPE);
            out.write("\n<html>\n<body>\n<h2>");
            out.print(taskid);
            out.write(" attempts for <a href=\"jobdetailshistory.jsp?jobid=");
            out.print(jobid);
            out.write("&&logFile=");
            out.print(encodedLogFileName);
            out.write(34);
            out.write(62);
            out.write(32);
            out.print(jobid);
            out.write(" </a></h2>\n<center>\n<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n<tr><td>Task Id</td><td>Start Time</td>\n");
            if (JobHistory.Values.REDUCE.name().equals(type)) {
                out.write("\n    <td>Shuffle Finished</td><td>Sort Finished</td>\n");
            }
            out.write("\n<td>Finish Time</td><td>Host</td><td>Error</td><td>Task Logs</td></tr>\n");
            for (JobHistory.TaskAttempt attempt : task.getTaskAttempts().values()) {
                this.printTaskAttempt(attempt, type, out);
            }
            out.write("\n</table>\n</center>\n");
            if (JobHistory.Values.MAP.name().equals(type)) {
                out.write("\n<h3>Input Split Locations</h3>\n<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
                for (String split : StringUtils.split(task.get(JobHistory.Keys.SPLITS))) {
                    out.println("<tr><td>" + split + "</td></tr>");
                }
                out.write("\n</table>    \n");
            }
            out.write(10);
            out.write("\n</body>\n</html>\n");
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

