# Clojure MXNet

A port of the scala package for mxnet to clojure.

## Usage

Go here to do the base package installation https://mxnet.incubator.apache.org/install/index.html

 Run `make scalapkg` then `make scalainstall`

then replace the correct jar for your architecture in the project.clj, example `[ml.dmlc.mxnet/mxnet-full_2.11-osx-x86_64-cpu "1.0.1-SNAPSHOT"]`

** Note - for testing purposes, there are pre-built binary jars in the native directory available **

### Generation of NDArray and Symbol apis

The bulk of the ndarray and symbol apis are generated via java relection into the Scala classes. To generate, use the `dev/generator.clj` file. Load in the repl and use the functions:

`(generate-ndarray-file)`
and
`(generate-symbol-file)`

These will generate the files under `src/org/apache/mxnet/gen/` that are loaded by the `src/org/apache/mxnet/ndarray.clj` and `src/org/apache/mxnet/symbol.clj` files.


## Tests
run `lein test`

## Current State

The current state is WIP. The goal is to completely port over the Scala package to Clojure and replicate the tests and examples.

## Punch List

* Flush out tutorial section (porting Scala web page) - done
* RNN example port - done
* Look into adding gpu OSX support for the scala artifacts
* Update to release 1.2.0
* Visualization example port
* multitask example port
* profiler example port
* customop port
* lein run task to automatically gen symbol, ndarray code
* Test out on clean install for rough edges
* Stage for testers: Pre-built binarys for linux/ linux gpu
* Document tester instructions
* Have testers test all builds
* Add license to each file
* PR for merge
* Maven build process
