/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderPinCache;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.exception.InvalidPinException;
import com.pi4j.io.gpio.exception.InvalidPinModeException;
import com.pi4j.io.gpio.exception.UnsupportedPinModeException;
import com.pi4j.io.gpio.exception.UnsupportedPinPullResistanceException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GpioProviderBase
implements GpioProvider {
    protected final Map<Pin, List<PinListener>> listeners = new ConcurrentHashMap<Pin, List<PinListener>>();
    protected final Map<Pin, GpioProviderPinCache> cache = new ConcurrentHashMap<Pin, GpioProviderPinCache>();

    @Override
    public abstract String getName();

    @Override
    public boolean hasPin(Pin pin) {
        return pin.getProvider() == this.getName();
    }

    protected GpioProviderPinCache getPinCache(Pin pin) {
        if (!this.cache.containsKey(pin)) {
            this.cache.put(pin, new GpioProviderPinCache(pin));
        }
        return this.cache.get(pin);
    }

    @Override
    public void export(Pin pin, PinMode mode) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new UnsupportedPinModeException(pin, mode);
        }
        this.getPinCache(pin).setExported(true);
        this.getPinCache(pin).setMode(mode);
    }

    @Override
    public boolean isExported(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).isExported();
    }

    @Override
    public void unexport(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        this.getPinCache(pin).setExported(false);
    }

    @Override
    public void setMode(Pin pin, PinMode mode) {
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; pin [" + pin.getName() + "] does not support this mode.");
        }
        if (!pin.getSupportedPinModes().contains((Object)mode)) {
            throw new UnsupportedPinModeException(pin, mode);
        }
        this.getPinCache(pin).setMode(mode);
    }

    @Override
    public PinMode getMode(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).getMode();
    }

    @Override
    public void setPullResistance(Pin pin, PinPullResistance resistance) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (!pin.getSupportedPinPullResistance().contains((Object)resistance)) {
            throw new UnsupportedPinPullResistanceException(pin, resistance);
        }
        this.getPinCache(pin).setResistance(resistance);
    }

    @Override
    public PinPullResistance getPullResistance(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).getResistance();
    }

    @Override
    public void setState(Pin pin, PinState state) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (mode != PinMode.DIGITAL_OUTPUT) {
            throw new InvalidPinModeException(pin, "Invalid pin mode on pin [" + pin.getName() + "]; cannot setState() when pin mode is [" + mode.getName() + "]");
        }
        this.getPinCache(pin).setState(state);
    }

    @Override
    public PinState getState(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (!PinMode.allDigital().contains((Object)mode)) {
            throw new InvalidPinModeException(pin, "Invalid pin mode on pin [" + pin.getName() + "]; cannot getState() when pin mode is [" + mode.getName() + "]");
        }
        return this.getPinCache(pin).getState();
    }

    @Override
    public void setValue(Pin pin, double value) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (!PinMode.allOutput().contains((Object)mode)) {
            throw new InvalidPinModeException(pin, "Invalid pin mode on pin [" + pin.getName() + "]; cannot setValue(" + value + ") when pin mode is [" + mode.getName() + "]");
        }
        this.getPinCache(pin).setAnalogValue(value);
    }

    @Override
    public double getValue(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (mode == PinMode.DIGITAL_OUTPUT) {
            return this.getState(pin).getValue();
        }
        return this.getPinCache(pin).getAnalogValue();
    }

    @Override
    public void setPwm(Pin pin, int value) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        PinMode mode = this.getMode(pin);
        if (mode != PinMode.PWM_OUTPUT) {
            throw new InvalidPinModeException(pin, "Invalid pin mode [" + mode.getName() + "]; unable to setPwm(" + value + ")");
        }
        this.getPinCache(pin).setPwmValue(value);
    }

    @Override
    public int getPwm(Pin pin) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        return this.getPinCache(pin).getPwmValue();
    }

    @Override
    public void addListener(Pin pin, PinListener listener) {
        List<PinListener> lsnrs;
        if (!this.listeners.containsKey(pin)) {
            this.listeners.put(pin, new ArrayList());
        }
        if (!(lsnrs = this.listeners.get(pin)).contains(listener)) {
            lsnrs.add(listener);
        }
    }

    @Override
    public void removeListener(Pin pin, PinListener listener) {
        if (this.listeners.containsKey(pin)) {
            List<PinListener> lsnrs = this.listeners.get(pin);
            if (lsnrs.contains(listener)) {
                lsnrs.remove(listener);
            }
            if (lsnrs.isEmpty()) {
                this.listeners.remove(pin);
            }
        }
    }

    @Override
    public void removeAllListeners() {
        for (Pin pin : this.listeners.keySet()) {
            for (PinListener listener : this.listeners.get(pin)) {
                this.removeListener(pin, listener);
            }
        }
    }

    protected void dispatchPinDigitalStateChangeEvent(Pin pin, PinState state) {
        if (this.listeners.containsKey(pin)) {
            for (PinListener listener : this.listeners.get(pin)) {
                listener.handlePinEvent(new PinDigitalStateChangeEvent((Object)this, pin, state));
            }
        }
    }

    protected void dispatchPinAnalogValueChangeEvent(Pin pin, double value) {
        if (this.listeners.containsKey(pin)) {
            for (PinListener listener : this.listeners.get(pin)) {
                listener.handlePinEvent(new PinAnalogValueChangeEvent((Object)this, pin, value));
            }
        }
    }
}

