/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial.impl;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataListener;
import com.pi4j.io.serial.impl.SerialDataMonitorThread;
import java.util.concurrent.CopyOnWriteArrayList;

public class SerialImpl
implements Serial {
    private int fileDescriptor = -1;
    private final CopyOnWriteArrayList<SerialDataListener> listeners = new CopyOnWriteArrayList();
    private SerialDataMonitorThread monitor;

    @Override
    public int open(String device, int baudRate) {
        this.fileDescriptor = com.pi4j.wiringpi.Serial.serialOpen(device, baudRate);
        return this.fileDescriptor;
    }

    @Override
    public boolean isOpen() {
        return this.fileDescriptor >= 0;
    }

    @Override
    public void close() {
        com.pi4j.wiringpi.Serial.serialClose(this.fileDescriptor);
    }

    @Override
    public void flush() {
        com.pi4j.wiringpi.Serial.serialFlush(this.fileDescriptor);
    }

    @Override
    public char read() {
        return (char)com.pi4j.wiringpi.Serial.serialGetchar(this.fileDescriptor);
    }

    @Override
    public void write(char data) {
        com.pi4j.wiringpi.Serial.serialPutchar(this.fileDescriptor, data);
    }

    @Override
    public void write(char[] data) {
        this.write(new String(data));
    }

    @Override
    public void write(byte data) {
        com.pi4j.wiringpi.Serial.serialPutchar(this.fileDescriptor, (char)data);
    }

    @Override
    public void write(byte[] data) {
        this.write(new String(data));
    }

    @Override
    public void write(String data) {
        int length;
        for (int position = 0; position < data.length(); position += length) {
            length = 1024;
            if (position + 1024 > data.length()) {
                com.pi4j.wiringpi.Serial.serialPuts(this.fileDescriptor, data.substring(position));
                continue;
            }
            com.pi4j.wiringpi.Serial.serialPuts(this.fileDescriptor, data.substring(position, position + length));
        }
    }

    @Override
    public void writeln(String data) {
        this.write(data + "\r\n");
    }

    @Override
    public void write(String data, String ... args) {
        this.write(String.format(data, args));
    }

    @Override
    public void writeln(String data, String ... args) {
        this.write(data + "\r\n", args);
    }

    @Override
    public int availableBytes() {
        return com.pi4j.wiringpi.Serial.serialDataAvail(this.fileDescriptor);
    }

    @Override
    public synchronized void addListener(SerialDataListener ... listener) {
        for (SerialDataListener lsnr : listener) {
            this.listeners.add(lsnr);
        }
        if (this.monitor == null || !this.monitor.isAlive()) {
            this.monitor = new SerialDataMonitorThread(this, this.listeners);
            this.monitor.start();
        }
    }

    @Override
    public synchronized void removeListener(SerialDataListener ... listener) {
        for (SerialDataListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
        if (this.listeners.isEmpty() && this.monitor != null) {
            this.monitor.exit();
            this.monitor = null;
        }
    }
}

