/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class SystemInfo {
    private static Map<String, String> cpuInfo;

    private SystemInfo() {
    }

    private static String getCpuInfo(String target) throws IOException, InterruptedException {
        if (cpuInfo == null) {
            cpuInfo = new HashMap<String, String>();
            Process p = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(":", 2);
                if (parts.length >= 2 && !parts[0].trim().isEmpty() && !parts[1].trim().isEmpty()) {
                    cpuInfo.put(parts[0].trim(), parts[1].trim());
                }
                line = reader.readLine();
            }
        }
        if (cpuInfo.containsKey(target)) {
            return cpuInfo.get(target);
        }
        throw new RuntimeException("Invalid target: " + target);
    }

    public static String getProcessor() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Processor");
    }

    public static String getBogoMIPS() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("BogoMIPS");
    }

    public static String[] getCpuFeatures() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Features").split(" ");
    }

    public static String getCpuImplementer() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU implementer");
    }

    public static String getCpuArchitecture() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU architecture");
    }

    public static String getCpuVariant() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU variant");
    }

    public static String getCpuPart() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU part");
    }

    public static String getCpuRevision() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("CPU revision");
    }

    public static String getHardware() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Hardware");
    }

    public static String getRevision() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Revision");
    }

    public static String getSerial() throws IOException, InterruptedException {
        return SystemInfo.getCpuInfo("Serial");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getOsArch() {
        return System.getProperty("os.arch");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static String getJavaVendorUrl() {
        return System.getProperty("java.vendor.url");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVirtualMachine() {
        return System.getProperty("java.vm.name");
    }

    public static String getJavaRuntime() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    public static boolean isHardFloatAbi() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            private final String[] gnueabihf = new String[]{"gnueabihf", "armhf"};

            @Override
            public Boolean run() {
                if (SystemInfo.contains(System.getProperty("sun.boot.library.path"), this.gnueabihf) || SystemInfo.contains(System.getProperty("java.library.path"), this.gnueabihf) || SystemInfo.contains(System.getProperty("java.home"), this.gnueabihf)) {
                    return true;
                }
                return false;
            }
        });
    }

    private static final boolean contains(String data, String[] search) {
        if (null != data && null != search) {
            for (int i = 0; i < search.length; ++i) {
                if (data.indexOf(search[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

