/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.weupnp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.bitlet.weupnp.GatewayDevice;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayDiscover {
    public static final int PORT = 1900;
    public static final String IP = "239.255.255.250";
    private static final int TIMEOUT = 3000;
    private Map<InetAddress, GatewayDevice> devices = new HashMap<InetAddress, GatewayDevice>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<InetAddress, GatewayDevice> discover() throws SocketException, UnknownHostException, IOException, SAXException, ParserConfigurationException {
        DatagramSocket ssdp = new DatagramSocket();
        int port = ssdp.getLocalPort();
        String searchMessage = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:" + port + "\r\n" + "ST: " + "urn:schemas-upnp-org:device:InternetGatewayDevice:1" + "\r\n" + "MAN: \"ssdp:discover\"\r\n" + "MX: 2\r\n" + "\r\n";
        try {
            byte[] searchMessageBytes = searchMessage.getBytes();
            DatagramPacket ssdpDiscoverPacket = new DatagramPacket(searchMessageBytes, searchMessageBytes.length);
            ssdpDiscoverPacket.setAddress(InetAddress.getByName(IP));
            ssdpDiscoverPacket.setPort(1900);
            ssdp.send(ssdpDiscoverPacket);
            ssdp.setSoTimeout(3000);
            boolean waitingPacket = true;
            while (waitingPacket) {
                DatagramPacket receivePacket = new DatagramPacket(new byte[1536], 1536);
                try {
                    ssdp.receive(receivePacket);
                    byte[] receivedData = new byte[receivePacket.getLength()];
                    System.arraycopy(receivePacket.getData(), 0, receivedData, 0, receivePacket.getLength());
                    GatewayDevice d = this.parseMSearchReplay(receivedData);
                    InetAddress localAddress = this.getOutboundAddress(receivePacket.getSocketAddress());
                    d.setLocalAddress(localAddress);
                    this.devices.put(localAddress, d);
                }
                catch (SocketTimeoutException ste) {
                    waitingPacket = false;
                }
            }
            for (GatewayDevice device : this.devices.values()) {
                try {
                    device.loadDescription();
                }
                catch (Exception e) {}
            }
        }
        finally {
            ssdp.close();
        }
        return this.devices;
    }

    private GatewayDevice parseMSearchReplay(byte[] reply) {
        GatewayDevice device = new GatewayDevice();
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(reply)));
        String line = null;
        try {
            line = br.readLine().trim();
        }
        catch (IOException ex) {
            // empty catch block
        }
        while (line != null && line.trim().length() > 0) {
            if (!line.startsWith("HTTP/1.")) {
                String key = line.substring(0, line.indexOf(58));
                String value = line.length() > key.length() + 1 ? line.substring(key.length() + 1) : null;
                key = key.trim();
                if (value != null) {
                    value = value.trim();
                }
                if (key.compareToIgnoreCase("location") == 0) {
                    device.setLocation(value);
                } else if (key.compareToIgnoreCase("st") == 0) {
                    device.setSt(value);
                }
            }
            try {
                line = br.readLine().trim();
            }
            catch (IOException ex) {}
        }
        return device;
    }

    public GatewayDevice getValidGateway() {
        for (GatewayDevice device : this.devices.values()) {
            try {
                if (!device.isConnected()) continue;
                return device;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private InetAddress getOutboundAddress(SocketAddress remoteAddress) throws SocketException {
        DatagramSocket sock = new DatagramSocket();
        sock.connect(remoteAddress);
        InetAddress localAddress = sock.getLocalAddress();
        sock.disconnect();
        sock = null;
        return localAddress;
    }
}

