/*
 * Decompiled with CFR 0.152.
 */
package org.bituf.clj_liquibase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.dbdoc.AuthorListWriter;
import liquibase.dbdoc.AuthorWriter;
import liquibase.dbdoc.ChangeLogListWriter;
import liquibase.dbdoc.ColumnWriter;
import liquibase.dbdoc.PendingChangesWriter;
import liquibase.dbdoc.PendingSQLWriter;
import liquibase.dbdoc.RecentChangesWriter;
import liquibase.dbdoc.TableListWriter;
import liquibase.dbdoc.TableWriter;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGeneratorFactory;
import liquibase.util.StreamUtil;

public class CustomDBDocVisitor
implements ChangeSetVisitor {
    private Database database;
    private SortedSet<ChangeLogInfo> changeLogs;
    private Map<DatabaseObject, List<Change>> changesByObject;
    private Map<String, List<Change>> changesByAuthor;
    private Map<DatabaseObject, List<Change>> changesToRunByObject;
    private Map<String, List<Change>> changesToRunByAuthor;
    private List<Change> changesToRun;
    private List<Change> recentChanges;
    private String rootChangeLogName;
    private DatabaseChangeLog rootChangeLog;
    private static final int MAX_RECENT_CHANGE = 50;

    public CustomDBDocVisitor(Database database) {
        this.database = database;
        this.changesByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesByAuthor = new HashMap<String, List<Change>>();
        this.changeLogs = new TreeSet<ChangeLogInfo>();
        this.changesToRunByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesToRunByAuthor = new HashMap<String, List<Change>>();
        this.changesToRun = new ArrayList<Change>();
        this.recentChanges = new ArrayList<Change>();
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) throws LiquibaseException {
        ChangeSet.RunStatus runStatus = this.database.getRunStatus(changeSet);
        if (this.rootChangeLogName == null) {
            this.rootChangeLogName = changeSet.getFilePath();
        }
        if (this.rootChangeLog == null) {
            this.rootChangeLog = databaseChangeLog;
        }
        if (!this.changesByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        if (!this.changesToRunByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesToRunByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        boolean toRun = runStatus.equals((Object)ChangeSet.RunStatus.NOT_RAN) || runStatus.equals((Object)ChangeSet.RunStatus.RUN_AGAIN);
        for (Change change : changeSet.getChanges()) {
            if (toRun) {
                this.changesToRunByAuthor.get(changeSet.getAuthor()).add(change);
                this.changesToRun.add(change);
                continue;
            }
            this.changesByAuthor.get(changeSet.getAuthor()).add(change);
            this.recentChanges.add(0, change);
        }
        ChangeLogInfo changeLogInfo = new ChangeLogInfo(changeSet.getFilePath(), databaseChangeLog.getPhysicalFilePath());
        if (!this.changeLogs.contains(changeLogInfo)) {
            this.changeLogs.add(changeLogInfo);
        }
        for (Change change : changeSet.getChanges()) {
            Set affectedDatabaseObjects = change.getAffectedDatabaseObjects(database);
            if (affectedDatabaseObjects == null) continue;
            for (DatabaseObject dbObject : affectedDatabaseObjects) {
                if (toRun) {
                    if (!this.changesToRunByObject.containsKey(dbObject)) {
                        this.changesToRunByObject.put(dbObject, new ArrayList());
                    }
                    this.changesToRunByObject.get(dbObject).add(change);
                }
                if (!this.changesByObject.containsKey(dbObject)) {
                    this.changesByObject.put(dbObject, new ArrayList());
                }
                this.changesByObject.get(dbObject).add(change);
            }
        }
    }

    public void writeHTML(File rootOutputDir, ResourceAccessor resourceAccessor) throws IOException, DatabaseException, DatabaseHistoryException {
        AuthorWriter authorWriter = new AuthorWriter(rootOutputDir, this.database);
        TableWriter tableWriter = new TableWriter(rootOutputDir, this.database);
        ColumnWriter columnWriter = new ColumnWriter(rootOutputDir, this.database);
        PendingChangesWriter pendingChangesWriter = new PendingChangesWriter(rootOutputDir, this.database);
        RecentChangesWriter recentChangesWriter = new RecentChangesWriter(rootOutputDir, this.database);
        PendingSQLWriter pendingSQLWriter = new PendingSQLWriter(rootOutputDir, this.database, this.rootChangeLog);
        this.copyFile("liquibase/dbdoc/stylesheet.css", rootOutputDir);
        this.copyFile("liquibase/dbdoc/index.html", rootOutputDir);
        this.copyFile("liquibase/dbdoc/globalnav.html", rootOutputDir);
        this.copyFile("liquibase/dbdoc/overview-summary.html", rootOutputDir);
        DatabaseSnapshot snapshot = DatabaseSnapshotGeneratorFactory.getInstance().createSnapshot(this.database, null, null);
        new ChangeLogListWriter(rootOutputDir).writeHTML(this.changeLogs);
        new TableListWriter(rootOutputDir).writeHTML(new TreeSet(snapshot.getTables()));
        new AuthorListWriter(rootOutputDir).writeHTML(new TreeSet<String>(this.changesByAuthor.keySet()));
        for (String author : this.changesByAuthor.keySet()) {
            authorWriter.writeHTML((Object)author, this.changesByAuthor.get(author), this.changesToRunByAuthor.get(author), this.rootChangeLogName);
        }
        for (Table table : snapshot.getTables()) {
            tableWriter.writeHTML((Object)table, this.changesByObject.get(table), this.changesToRunByObject.get(table), this.rootChangeLogName);
        }
        for (Column column : snapshot.getColumns()) {
            columnWriter.writeHTML((Object)column, this.changesByObject.get(column), this.changesToRunByObject.get(column), this.rootChangeLogName);
        }
        pendingChangesWriter.writeHTML((Object)"index", null, this.changesToRun, this.rootChangeLogName);
        pendingSQLWriter.writeHTML((Object)"sql", null, this.changesToRun, this.rootChangeLogName);
        if (this.recentChanges.size() > 50) {
            this.recentChanges = this.recentChanges.subList(0, 50);
        }
        recentChangesWriter.writeHTML((Object)"index", this.recentChanges, null, this.rootChangeLogName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String fileToCopy, File rootOutputDir) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileToCopy);
        FileOutputStream outputStream = null;
        try {
            if (inputStream == null) {
                throw new IOException("Can not find " + fileToCopy);
            }
            outputStream = new FileOutputStream(new File(rootOutputDir, fileToCopy.replaceFirst(".*\\/", "")), false);
            StreamUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeLogInfo
    implements Comparable<ChangeLogInfo> {
        public String logicalPath;
        public String physicalPath;

        private ChangeLogInfo(String logicalPath, String physicalPath) {
            this.logicalPath = logicalPath;
            this.physicalPath = physicalPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeLogInfo that = (ChangeLogInfo)o;
            return this.logicalPath.equals(that.logicalPath);
        }

        public int hashCode() {
            return this.logicalPath.hashCode();
        }

        @Override
        public int compareTo(ChangeLogInfo o) {
            return this.logicalPath.compareTo(o.logicalPath);
        }

        public String toString() {
            return this.logicalPath;
        }
    }
}

