/*
 * Decompiled with CFR 0.152.
 */
package org.bitumenframework.jettify;

import java.net.URL;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;

public class JettyServer {
    public final Server server;
    public final Context root;

    public JettyServer() {
        this("/", 8088);
    }

    public JettyServer(int port) {
        this("/", port);
    }

    public JettyServer(String context, int port) {
        this.server = new Server(port);
        this.root = new Context((HandlerContainer)this.server, context, 1);
    }

    public void setWebAppDirInClassPath(String webAppDirInClassPath) {
        URL warUrl = this.getClass().getClassLoader().getResource(webAppDirInClassPath);
        String warUrlString = warUrl.toExternalForm();
        this.setWebAppDir(warUrlString);
    }

    public void setWebAppDir(String webAppDir) {
        String contextPath = this.root.getContextPath();
        this.server.setHandler((Handler)new WebAppContext(webAppDir, contextPath));
    }

    public void addServlet(Servlet servlet, String servletPath) {
        this.root.addServlet(new ServletHolder(servlet), servletPath);
    }

    public void addFilter(Filter filter, String filterPath) {
        this.root.addFilter(new FilterHolder(filter), filterPath, 0);
    }

    public void addListener(EventListener listener) {
        this.root.addEventListener(listener);
    }

    public void setResourceBase(String webappDir) {
        this.root.setResourceBase(webappDir);
        this.root.setHandler((Handler)new ResourceHandler());
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

