/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class LabelNode
extends Node {
    private IdentNode label;
    private Block body;
    @Ignore
    private Node breakNode;
    @Ignore
    private Node continueNode;

    public LabelNode(Source source, long token, int finish, IdentNode label, Block body) {
        super(source, token, finish);
        this.label = label;
        this.body = body;
    }

    private LabelNode(LabelNode labelNode, Node.CopyState cs) {
        super(labelNode);
        this.label = (IdentNode)cs.existingOrCopy(labelNode.label);
        this.body = (Block)cs.existingOrCopy(labelNode.body);
        this.breakNode = cs.existingOrSame(labelNode.breakNode);
        this.continueNode = cs.existingOrSame(labelNode.continueNode);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new LabelNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.label = (IdentNode)this.label.accept(visitor);
            this.body = (Block)this.body.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        this.label.toString(sb);
        sb.append(':');
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        this.body = body;
    }

    public Node getBreakNode() {
        return this.breakNode;
    }

    public void setBreakNode(Node breakNode) {
        this.breakNode = breakNode;
    }

    public Node getContinueNode() {
        return this.continueNode;
    }

    public void setContinueNode(Node continueNode) {
        this.continueNode = continueNode;
    }

    public IdentNode getLabel() {
        return this.label;
    }
}

