/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.parser;

import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jdk.nashorn.internal.parser.RegExpScanner;
import jdk.nashorn.internal.runtime.BitVector;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ParserException;

public final class RegExp {
    private final String input;
    private boolean global;
    private boolean ignoreCase;
    private boolean multiline;
    private Pattern pattern;
    private BitVector groupsInNegativeLookahead;

    public RegExp(String input, String flagString) throws ParserException {
        this.input = input;
        HashSet<Character> usedFlags = new HashSet<Character>();
        int flags = 0;
        block9: for (char ch : flagString.toCharArray()) {
            if (usedFlags.contains(Character.valueOf(ch))) {
                RegExp.throwParserException("repeated.flag", Character.toString(ch));
            }
            switch (ch) {
                case 'g': {
                    this.global = true;
                    usedFlags.add(Character.valueOf(ch));
                    continue block9;
                }
                case 'i': {
                    this.ignoreCase = true;
                    flags |= 0x42;
                    usedFlags.add(Character.valueOf(ch));
                    continue block9;
                }
                case 'm': {
                    this.multiline = true;
                    flags |= 8;
                    usedFlags.add(Character.valueOf(ch));
                    continue block9;
                }
                default: {
                    RegExp.throwParserException("unsupported.flag", Character.toString(ch));
                }
            }
        }
        try {
            RegExpScanner parsed;
            try {
                parsed = RegExpScanner.scan(input);
            }
            catch (PatternSyntaxException e) {
                Pattern.compile(input, flags);
                throw e;
            }
            if (parsed != null) {
                this.pattern = Pattern.compile(parsed.getJavaPattern(), flags);
                this.groupsInNegativeLookahead = parsed.getGroupsInNegativeLookahead();
            }
        }
        catch (PatternSyntaxException e2) {
            RegExp.throwParserException("syntax", e2.getMessage());
        }
    }

    public String getInput() {
        return this.input;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public BitVector getGroupsInNegativeLookahead() {
        return this.groupsInNegativeLookahead;
    }

    public static void validate(String input, String flagString) throws ParserException {
        new RegExp(input, flagString);
    }

    private static void throwParserException(String key, String str) throws ParserException {
        throw new ParserException(ECMAErrors.getMessage("parser.error.regex." + key, str));
    }
}

