/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.linker.JavaAdapterFactory;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.beans.BeansLinker;
import org.dynalang.dynalink.beans.StaticClass;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.GuardingDynamicLinker;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.dynalang.dynalink.support.Guards;

class NashornStaticClassLinker
implements TypeBasedGuardingDynamicLinker {
    private static final GuardingDynamicLinker staticClassLinker = BeansLinker.getLinkerForClass(StaticClass.class);

    NashornStaticClassLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return type == StaticClass.class;
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        LinkRequest request = linkRequest.withoutRuntimeContext();
        Object self = request.getReceiver();
        if (self.getClass() != StaticClass.class) {
            return null;
        }
        CallSiteDescriptor desc = request.getCallSiteDescriptor();
        if ("new".equals(desc.getNameToken(1))) {
            Class<?> receiverClass = ((StaticClass)self).getRepresentedClass();
            if (JavaAdapterFactory.isAbstractClass(receiverClass)) {
                Object[] args = request.getArguments();
                args[0] = JavaAdapterFactory.getAdapterClassFor(new Class[]{receiverClass});
                LinkRequest adapterRequest = request.replaceArguments(request.getCallSiteDescriptor(), args);
                GuardedInvocation gi = NashornStaticClassLinker.checkNullConstructor(NashornStaticClassLinker.delegate(linkerServices, adapterRequest), receiverClass);
                return gi.replaceMethods(gi.getInvocation(), Guards.getIdentityGuard(self));
            }
            return NashornStaticClassLinker.checkNullConstructor(NashornStaticClassLinker.delegate(linkerServices, request), receiverClass);
        }
        return NashornStaticClassLinker.delegate(linkerServices, request);
    }

    private static GuardedInvocation delegate(LinkerServices linkerServices, LinkRequest request) throws Exception {
        return staticClassLinker.getGuardedInvocation(request, linkerServices);
    }

    private static GuardedInvocation checkNullConstructor(GuardedInvocation ctorInvocation, Class<?> receiverClass) {
        if (ctorInvocation == null) {
            ECMAErrors.typeError("no.constructor.matches.args", receiverClass.getName());
        }
        return ctorInvocation;
    }
}

