/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.List;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.NoSuchDynamicMethodException;
import org.dynalang.dynalink.RelinkableCallSite;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.support.LinkRequestImpl;
import org.dynalang.dynalink.support.Lookup;
import org.dynalang.dynalink.support.RuntimeContextLinkRequestImpl;

public class DynamicLinker {
    private static final String CLASS_NAME = DynamicLinker.class.getName();
    private static final String RELINK_METHOD_NAME = "relink";
    private final LinkerServices linkerServices;
    private final int runtimeContextArgCount;
    private final boolean syncOnRelink;
    private final int unstableRelinkThreshold;
    private static final MethodHandle RELINK = Lookup.findOwnSpecial(MethodHandles.lookup(), "relink", MethodHandle.class, RelinkableCallSite.class, Integer.TYPE, Object[].class);

    DynamicLinker(LinkerServices linkerServices, int runtimeContextArgCount, boolean syncOnRelink, int unstableRelinkThreshold) {
        if (runtimeContextArgCount < 0) {
            throw new IllegalArgumentException("runtimeContextArgCount < 0");
        }
        if (unstableRelinkThreshold < 0) {
            throw new IllegalArgumentException("unstableRelinkThreshold < 0");
        }
        this.runtimeContextArgCount = runtimeContextArgCount;
        this.linkerServices = linkerServices;
        this.syncOnRelink = syncOnRelink;
        this.unstableRelinkThreshold = unstableRelinkThreshold;
    }

    public <T extends RelinkableCallSite> T link(T callSite) {
        callSite.initialize(this.createRelinkAndInvokeMethod(callSite, 0));
        return callSite;
    }

    public LinkerServices getLinkerServices() {
        return this.linkerServices;
    }

    private MethodHandle createRelinkAndInvokeMethod(RelinkableCallSite callSite, int relinkCount) {
        MethodHandle boundRelinker = MethodHandles.insertArguments(RELINK, 0, this, callSite, relinkCount);
        MethodType type = callSite.getDescriptor().getMethodType();
        MethodHandle collectingRelinker = boundRelinker.asCollector(Object[].class, type.parameterCount());
        return MethodHandles.foldArguments(MethodHandles.exactInvoker(type), collectingRelinker.asType(type.changeReturnType(MethodHandle.class)));
    }

    private MethodHandle relink(RelinkableCallSite callSite, int relinkCount, Object ... arguments) throws Exception {
        CallSiteDescriptor callSiteDescriptor = callSite.getDescriptor();
        boolean unstableDetectionEnabled = this.unstableRelinkThreshold > 0;
        boolean callSiteUnstable = unstableDetectionEnabled && relinkCount >= this.unstableRelinkThreshold;
        LinkRequestImpl linkRequest = this.runtimeContextArgCount == 0 ? new LinkRequestImpl(callSiteDescriptor, callSiteUnstable, arguments) : new RuntimeContextLinkRequestImpl(callSiteDescriptor, callSiteUnstable, arguments, this.runtimeContextArgCount);
        GuardedInvocation guardedInvocation = this.linkerServices.getGuardedInvocation(linkRequest);
        if (guardedInvocation == null) {
            throw new NoSuchDynamicMethodException(callSiteDescriptor.toString());
        }
        if (this.runtimeContextArgCount > 0) {
            MethodType origType = callSiteDescriptor.getMethodType();
            MethodHandle invocation = guardedInvocation.getInvocation();
            if (invocation.type().parameterCount() == origType.parameterCount() - this.runtimeContextArgCount) {
                List<Class<?>> prefix = origType.parameterList().subList(1, this.runtimeContextArgCount + 1);
                MethodHandle guard = guardedInvocation.getGuard();
                guardedInvocation = guardedInvocation.dropArguments(1, prefix);
            }
        }
        if (unstableDetectionEnabled && relinkCount <= this.unstableRelinkThreshold && relinkCount++ == this.unstableRelinkThreshold) {
            callSite.resetAndRelink(guardedInvocation, this.createRelinkAndInvokeMethod(callSite, relinkCount));
        } else {
            callSite.relink(guardedInvocation, this.createRelinkAndInvokeMethod(callSite, relinkCount));
        }
        if (this.syncOnRelink) {
            MutableCallSite.syncAll(new MutableCallSite[]{(MutableCallSite)((Object)callSite)});
        }
        return guardedInvocation.getInvocation();
    }

    public static StackTraceElement getRelinkedCallSiteLocation() {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        for (int i = 0; i < trace.length - 1; ++i) {
            StackTraceElement frame = trace[i];
            if (!RELINK_METHOD_NAME.equals(frame.getMethodName()) || !CLASS_NAME.equals(frame.getClassName())) continue;
            return trace[i + 1];
        }
        return null;
    }
}

