/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.dynalang.dynalink.beans.AccessibleMembersLookup;
import org.dynalang.dynalink.beans.CheckRestrictedPackage;
import org.dynalang.dynalink.support.Lookup;

abstract class FacetIntrospector
implements AutoCloseable {
    protected final Class<?> clazz;
    protected final boolean isRestricted;
    protected final AccessibleMembersLookup membersLookup;

    FacetIntrospector(Class<?> clazz, boolean instance) {
        this.clazz = clazz;
        this.isRestricted = CheckRestrictedPackage.isRestrictedClass(clazz);
        this.membersLookup = new AccessibleMembersLookup(clazz, instance);
    }

    abstract Collection<PropertyDescriptor> getProperties();

    abstract Map<String, MethodHandle> getInnerClassGetters();

    Collection<Field> getFields() {
        if (this.isRestricted) {
            return Collections.emptySet();
        }
        Field[] fields = this.clazz.getFields();
        ArrayList<Field> cfields = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (!this.isAccessible(field) || !this.includeField(field)) continue;
            cfields.add(field);
        }
        return cfields;
    }

    boolean isAccessible(Member m) {
        Class<?> declaring = m.getDeclaringClass();
        return declaring == this.clazz || !CheckRestrictedPackage.isRestrictedClass(declaring);
    }

    abstract boolean includeField(Field var1);

    abstract Collection<Method> getMethods();

    MethodHandle unreflectGetter(Field field) {
        return this.editMethodHandle(Lookup.PUBLIC.unreflectGetter(field));
    }

    MethodHandle unreflectSetter(Field field) {
        return this.editMethodHandle(Lookup.PUBLIC.unreflectSetter(field));
    }

    MethodHandle unreflect(Method method) {
        return this.editMethodHandle(Lookup.PUBLIC.unreflect(method));
    }

    MethodHandle editMethodHandle(MethodHandle mh) {
        return mh;
    }

    @Override
    public void close() {
    }
}

