/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dynalang.dynalink.beans.FacetIntrospector;
import org.dynalang.dynalink.beans.StaticClass;

class StaticClassIntrospector
extends FacetIntrospector {
    private final Method[] methods;

    StaticClassIntrospector(Class<?> clazz) {
        super(clazz, false);
        this.methods = this.membersLookup.getMethods();
    }

    @Override
    Collection<PropertyDescriptor> getProperties() {
        HashMap<String, PropertyDescriptor> descs = new HashMap<String, PropertyDescriptor>();
        for (Method method : this.methods) {
            if (method.isBridge() || method.isSynthetic() || method.getReturnType() == Void.TYPE) continue;
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0) {
                StaticClassIntrospector.addPropertyDescriptor(descs, method, Introspector.decapitalize(name.substring(3)));
                continue;
            }
            if (!name.startsWith("is") || name.length() <= 2 || method.getParameterTypes().length != 0) continue;
            StaticClassIntrospector.addPropertyDescriptor(descs, method, Introspector.decapitalize(name.substring(2)));
        }
        return descs.values();
    }

    private static void addPropertyDescriptor(Map<String, PropertyDescriptor> descs, Method method, String name) {
        if (!descs.containsKey(name)) {
            try {
                descs.put(name, new PropertyDescriptor(name, method, null));
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    Map<String, MethodHandle> getInnerClassGetters() {
        HashMap<String, MethodHandle> map = new HashMap<String, MethodHandle>();
        for (Class<?> innerClass : this.membersLookup.getInnerClasses()) {
            map.put(innerClass.getSimpleName(), this.editMethodHandle(MethodHandles.constant(StaticClass.class, StaticClass.forClass(innerClass))));
        }
        return map;
    }

    @Override
    boolean includeField(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    @Override
    Collection<Method> getMethods() {
        ArrayList<Method> cmethods = new ArrayList<Method>(this.methods.length);
        for (Method method : this.methods) {
            if (method.isBridge() || method.isSynthetic()) continue;
            cmethods.add(method);
        }
        return cmethods;
    }

    @Override
    MethodHandle editMethodHandle(MethodHandle mh) {
        MethodHandle newHandle = MethodHandles.dropArguments(mh, 0, new Class[]{Object.class});
        if (mh.isVarargsCollector() && !newHandle.isVarargsCollector()) {
            MethodType type = mh.type();
            newHandle = newHandle.asVarargsCollector((Class<?>)type.parameterType(type.parameterCount() - 1));
        }
        return newHandle;
    }
}

