/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.dynalink.beans;

import java.beans.Introspector;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.beans.CheckRestrictedPackage;
import jdk.internal.dynalink.beans.DynamicMethod;
import jdk.internal.dynalink.beans.FacetIntrospector;
import jdk.internal.dynalink.beans.GuardedInvocationComponent;
import jdk.internal.dynalink.beans.OverloadedDynamicMethod;
import jdk.internal.dynalink.beans.SimpleDynamicMethod;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.GuardingDynamicLinker;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.support.CallSiteDescriptorFactory;
import jdk.internal.dynalink.support.Guards;
import jdk.internal.dynalink.support.Lookup;

abstract class AbstractJavaLinker
implements GuardingDynamicLinker {
    final Class<?> clazz;
    private final MethodHandle classGuard;
    private final MethodHandle assignableGuard;
    private final Map<String, AnnotatedMethodHandle> propertyGetters = new HashMap<String, AnnotatedMethodHandle>();
    private final Map<String, DynamicMethod> propertySetters = new HashMap<String, DynamicMethod>();
    private final Map<String, DynamicMethod> methods = new HashMap<String, DynamicMethod>();
    private static final MethodHandle IS_METHOD_HANDLE_NOT_NULL = Guards.isNotNull().asType(MethodType.methodType(Boolean.TYPE, MethodHandle.class));
    private static final MethodHandle CONSTANT_NULL_DROP_METHOD_HANDLE = MethodHandles.dropArguments(MethodHandles.constant(Object.class, null), 0, new Class[]{MethodHandle.class});
    private static final Lookup privateLookup = new Lookup(MethodHandles.lookup());
    private static final MethodHandle IS_ANNOTATED_HANDLE_NOT_NULL = Guards.isNotNull().asType(MethodType.methodType(Boolean.TYPE, AnnotatedMethodHandle.class));
    private static final MethodHandle CONSTANT_NULL_DROP_ANNOTATED_HANDLE = MethodHandles.dropArguments(MethodHandles.constant(Object.class, null), 0, new Class[]{AnnotatedMethodHandle.class});
    private static final MethodHandle GET_ANNOTATED_HANDLE = privateLookup.findGetter(AnnotatedMethodHandle.class, "handle", MethodHandle.class);
    private static final MethodHandle GENERIC_PROPERTY_GETTER_HANDLER_INVOKER = MethodHandles.filterArguments(MethodHandles.invoker(MethodType.methodType(Object.class, Object.class)), 0, GET_ANNOTATED_HANDLE);
    private static final MethodHandle IS_DYNAMIC_METHOD_NOT_NULL = Guards.asType(Guards.isNotNull(), MethodType.methodType(Boolean.TYPE, DynamicMethod.class));
    private static final MethodHandle DYNAMIC_METHOD_IDENTITY = MethodHandles.identity(DynamicMethod.class);
    private static MethodHandle GET_PROPERTY_GETTER_HANDLE = MethodHandles.dropArguments(privateLookup.findOwnSpecial("getPropertyGetterHandle", Object.class, Object.class), 1, new Class[]{Object.class});
    private final MethodHandle getPropertyGetterHandle = GET_PROPERTY_GETTER_HANDLE.bindTo(this);
    private static final MethodHandle GET_PROPERTY_SETTER_HANDLE = MethodHandles.dropArguments(MethodHandles.dropArguments(privateLookup.findOwnSpecial("getPropertySetterHandle", MethodHandle.class, MethodType.class, LinkerServices.class, Object.class), 3, new Class[]{Object.class}), 5, new Class[]{Object.class});
    private final MethodHandle getPropertySetterHandle = GET_PROPERTY_SETTER_HANDLE.bindTo(this);
    private static MethodHandle GET_DYNAMIC_METHOD = MethodHandles.dropArguments(privateLookup.findOwnSpecial("getDynamicMethod", DynamicMethod.class, Object.class), 1, new Class[]{Object.class});
    private final MethodHandle getDynamicMethod = GET_DYNAMIC_METHOD.bindTo(this);

    AbstractJavaLinker(Class<?> clazz, MethodHandle classGuard) {
        this(clazz, classGuard, classGuard);
    }

    AbstractJavaLinker(Class<?> clazz, MethodHandle classGuard, MethodHandle assignableGuard) {
        String name;
        this.clazz = clazz;
        this.classGuard = classGuard;
        this.assignableGuard = assignableGuard;
        FacetIntrospector introspector = this.createFacetIntrospector();
        for (Method method : introspector.getMethods()) {
            name = method.getName();
            MethodHandle methodHandle = introspector.unreflect(method);
            this.addMember(name, methodHandle, this.methods);
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0) {
                this.setPropertyGetter(Introspector.decapitalize(name.substring(3)), introspector.unreflect(AbstractJavaLinker.getMostGenericGetter(method)), GuardedInvocationComponent.ValidationType.INSTANCE_OF);
                continue;
            }
            if (name.startsWith("is") && name.length() > 2 && method.getParameterTypes().length == 0 && method.getReturnType() == Boolean.TYPE) {
                this.setPropertyGetter(Introspector.decapitalize(name.substring(2)), introspector.unreflect(AbstractJavaLinker.getMostGenericGetter(method)), GuardedInvocationComponent.ValidationType.INSTANCE_OF);
                continue;
            }
            if (!name.startsWith("set") || name.length() <= 3 || method.getParameterTypes().length != 1) continue;
            this.addMember(Introspector.decapitalize(name.substring(3)), methodHandle, this.propertySetters);
        }
        for (Field field : introspector.getFields()) {
            name = field.getName();
            if (!this.propertyGetters.containsKey(name)) {
                this.setPropertyGetter(name, introspector.unreflectGetter(field), GuardedInvocationComponent.ValidationType.EXACT_CLASS);
            }
            if (Modifier.isFinal(field.getModifiers()) || this.propertySetters.containsKey(name)) continue;
            this.addMember(name, introspector.unreflectSetter(field), this.propertySetters);
        }
        for (Map.Entry entry : introspector.getInnerClassGetters().entrySet()) {
            name = (String)entry.getKey();
            if (this.propertyGetters.containsKey(name)) continue;
            this.setPropertyGetter(name, (MethodHandle)entry.getValue(), GuardedInvocationComponent.ValidationType.EXACT_CLASS);
        }
    }

    abstract FacetIntrospector createFacetIntrospector();

    void setPropertyGetter(String name, MethodHandle handle, GuardedInvocationComponent.ValidationType validationType) {
        this.propertyGetters.put(name, new AnnotatedMethodHandle(handle, validationType));
    }

    private void addMember(String name, MethodHandle mh, Map<String, DynamicMethod> methodMap) {
        DynamicMethod existingMethod = methodMap.get(name);
        DynamicMethod newMethod = AbstractJavaLinker.addMember(mh, existingMethod, this.clazz, name);
        if (newMethod != existingMethod) {
            methodMap.put(name, newMethod);
        }
    }

    static DynamicMethod createDynamicMethod(Iterable<MethodHandle> methodHandles, Class<?> clazz, String name) {
        DynamicMethod dynMethod = null;
        for (MethodHandle methodHandle : methodHandles) {
            dynMethod = AbstractJavaLinker.addMember(methodHandle, dynMethod, clazz, name);
        }
        return dynMethod;
    }

    private static DynamicMethod addMember(MethodHandle mh, DynamicMethod existing, Class<?> clazz, String name) {
        if (existing == null) {
            return new SimpleDynamicMethod(mh, clazz, name);
        }
        if (existing.contains(mh)) {
            return existing;
        }
        if (existing instanceof SimpleDynamicMethod) {
            OverloadedDynamicMethod odm = new OverloadedDynamicMethod(clazz, name);
            odm.addMethod((SimpleDynamicMethod)existing);
            odm.addMethod(mh);
            return odm;
        }
        if (existing instanceof OverloadedDynamicMethod) {
            ((OverloadedDynamicMethod)existing).addMethod(mh);
            return existing;
        }
        throw new AssertionError();
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest request, LinkerServices linkerServices) throws Exception {
        LinkRequest ncrequest = request.withoutRuntimeContext();
        CallSiteDescriptor callSiteDescriptor = ncrequest.getCallSiteDescriptor();
        String op = callSiteDescriptor.getNameToken(1);
        if ("callMethod" == op) {
            return this.getCallPropWithThis(callSiteDescriptor, linkerServices);
        }
        List<String> operations = CallSiteDescriptorFactory.tokenizeOperators(callSiteDescriptor);
        while (!operations.isEmpty()) {
            GuardedInvocationComponent gic = this.getGuardedInvocationComponent(callSiteDescriptor, linkerServices, operations);
            if (gic != null) {
                return gic.getGuardedInvocation();
            }
            operations = AbstractJavaLinker.pop(operations);
        }
        return null;
    }

    protected GuardedInvocationComponent getGuardedInvocationComponent(CallSiteDescriptor callSiteDescriptor, LinkerServices linkerServices, List<String> operations) throws Exception {
        if (operations.isEmpty()) {
            return null;
        }
        String op = operations.get(0);
        if ("getProp".equals(op)) {
            return this.getPropertyGetter(callSiteDescriptor, linkerServices, AbstractJavaLinker.pop(operations));
        }
        if ("setProp".equals(op)) {
            return this.getPropertySetter(callSiteDescriptor, linkerServices, AbstractJavaLinker.pop(operations));
        }
        if ("getMethod".equals(op)) {
            return this.getMethodGetter(callSiteDescriptor, linkerServices, AbstractJavaLinker.pop(operations));
        }
        return null;
    }

    static final <T> List<T> pop(List<T> l) {
        return l.subList(1, l.size());
    }

    MethodHandle getClassGuard(CallSiteDescriptor desc) {
        return this.getClassGuard(desc.getMethodType());
    }

    MethodHandle getClassGuard(MethodType type) {
        return Guards.asType(this.classGuard, type);
    }

    GuardedInvocationComponent getClassGuardedInvocationComponent(MethodHandle invocation, MethodType type) {
        return new GuardedInvocationComponent(invocation, this.getClassGuard(type), this.clazz, GuardedInvocationComponent.ValidationType.EXACT_CLASS);
    }

    private MethodHandle getAssignableGuard(MethodType type) {
        return Guards.asType(this.assignableGuard, type);
    }

    private GuardedInvocation getCallPropWithThis(CallSiteDescriptor callSiteDescriptor, LinkerServices linkerServices) {
        switch (callSiteDescriptor.getNameTokenCount()) {
            case 3: {
                return this.createGuardedDynamicMethodInvocation(callSiteDescriptor.getMethodType(), linkerServices, callSiteDescriptor.getNameToken(2), this.methods);
            }
        }
        return null;
    }

    private GuardedInvocation createGuardedDynamicMethodInvocation(MethodType callSiteType, LinkerServices linkerServices, String methodName, Map<String, DynamicMethod> methodMap) {
        MethodHandle inv = AbstractJavaLinker.getDynamicMethodInvocation(callSiteType, linkerServices, methodName, methodMap);
        return inv == null ? null : new GuardedInvocation(inv, this.getClassGuard(callSiteType));
    }

    private static MethodHandle getDynamicMethodInvocation(MethodType callSiteType, LinkerServices linkerServices, String methodName, Map<String, DynamicMethod> methodMap) {
        DynamicMethod dynaMethod = AbstractJavaLinker.getDynamicMethod(methodName, methodMap);
        return dynaMethod != null ? dynaMethod.getInvocation(callSiteType, linkerServices) : null;
    }

    private static DynamicMethod getDynamicMethod(String methodName, Map<String, DynamicMethod> methodMap) {
        DynamicMethod dynaMethod = methodMap.get(methodName);
        return dynaMethod != null ? dynaMethod : AbstractJavaLinker.getExplicitSignatureDynamicMethod(methodName, methodMap);
    }

    private static SimpleDynamicMethod getExplicitSignatureDynamicMethod(String methodName, Map<String, DynamicMethod> methodsMap) {
        int lastChar = methodName.length() - 1;
        if (methodName.charAt(lastChar) != ')') {
            return null;
        }
        int openBrace = methodName.indexOf(40);
        if (openBrace == -1) {
            return null;
        }
        DynamicMethod simpleNamedMethod = methodsMap.get(methodName.substring(0, openBrace));
        if (simpleNamedMethod == null) {
            return null;
        }
        return simpleNamedMethod.getMethodForExactParamTypes(methodName.substring(openBrace + 1, lastChar));
    }

    private GuardedInvocationComponent getPropertySetter(CallSiteDescriptor callSiteDescriptor, LinkerServices linkerServices, List<String> operations) throws Exception {
        MethodType type = callSiteDescriptor.getMethodType();
        switch (callSiteDescriptor.getNameTokenCount()) {
            case 2: {
                AbstractJavaLinker.assertParameterCount(callSiteDescriptor, 3);
                MethodType setterType = type.dropParameterTypes(1, 2);
                MethodHandle boundGetter = MethodHandles.insertArguments(this.getPropertySetterHandle, 0, setterType, linkerServices);
                MethodHandle typedGetter = linkerServices.asType(boundGetter, type.changeReturnType(MethodHandle.class));
                MethodHandle invokeHandle = MethodHandles.exactInvoker(setterType);
                MethodHandle invokeHandleFolded = MethodHandles.dropArguments(invokeHandle, 2, new Class[]{type.parameterType(1)});
                GuardedInvocationComponent nextComponent = this.getGuardedInvocationComponent(callSiteDescriptor, linkerServices, operations);
                MethodHandle fallbackFolded = nextComponent == null ? MethodHandles.dropArguments(CONSTANT_NULL_DROP_METHOD_HANDLE, 1, type.parameterList()).asType(type.insertParameterTypes(0, MethodHandle.class)) : MethodHandles.dropArguments(nextComponent.getGuardedInvocation().getInvocation(), 0, new Class[]{MethodHandle.class});
                MethodHandle compositeSetter = MethodHandles.foldArguments(MethodHandles.guardWithTest(IS_METHOD_HANDLE_NOT_NULL, invokeHandleFolded, fallbackFolded), typedGetter);
                if (nextComponent == null) {
                    return this.getClassGuardedInvocationComponent(compositeSetter, type);
                }
                return nextComponent.compose(compositeSetter, this.getClassGuard(type), this.clazz, GuardedInvocationComponent.ValidationType.EXACT_CLASS);
            }
            case 3: {
                AbstractJavaLinker.assertParameterCount(callSiteDescriptor, 2);
                GuardedInvocation gi = this.createGuardedDynamicMethodInvocation(callSiteDescriptor.getMethodType(), linkerServices, callSiteDescriptor.getNameToken(2), this.propertySetters);
                if (gi != null) {
                    return new GuardedInvocationComponent(gi, this.clazz, GuardedInvocationComponent.ValidationType.EXACT_CLASS);
                }
                return this.getGuardedInvocationComponent(callSiteDescriptor, linkerServices, operations);
            }
        }
        return null;
    }

    private GuardedInvocationComponent getPropertyGetter(CallSiteDescriptor callSiteDescriptor, LinkerServices linkerServices, List<String> ops) throws Exception {
        MethodType type = callSiteDescriptor.getMethodType();
        switch (callSiteDescriptor.getNameTokenCount()) {
            case 2: {
                AbstractJavaLinker.assertParameterCount(callSiteDescriptor, 2);
                MethodHandle typedGetter = linkerServices.asType(this.getPropertyGetterHandle, type.changeReturnType(AnnotatedMethodHandle.class));
                MethodHandle invokeHandleTyped = linkerServices.asType(GENERIC_PROPERTY_GETTER_HANDLER_INVOKER, MethodType.methodType(type.returnType(), AnnotatedMethodHandle.class, new Class[]{type.parameterType(0)}));
                MethodHandle invokeHandleFolded = MethodHandles.dropArguments(invokeHandleTyped, 2, new Class[]{type.parameterType(1)});
                GuardedInvocationComponent nextComponent = this.getGuardedInvocationComponent(callSiteDescriptor, linkerServices, ops);
                MethodHandle fallbackFolded = nextComponent == null ? MethodHandles.dropArguments(CONSTANT_NULL_DROP_ANNOTATED_HANDLE, 1, type.parameterList()).asType(type.insertParameterTypes(0, AnnotatedMethodHandle.class)) : MethodHandles.dropArguments(nextComponent.getGuardedInvocation().getInvocation(), 0, new Class[]{AnnotatedMethodHandle.class});
                MethodHandle compositeGetter = MethodHandles.foldArguments(MethodHandles.guardWithTest(IS_ANNOTATED_HANDLE_NOT_NULL, invokeHandleFolded, fallbackFolded), typedGetter);
                if (nextComponent == null) {
                    return this.getClassGuardedInvocationComponent(compositeGetter, type);
                }
                return nextComponent.compose(compositeGetter, this.getClassGuard(type), this.clazz, GuardedInvocationComponent.ValidationType.EXACT_CLASS);
            }
            case 3: {
                AbstractJavaLinker.assertParameterCount(callSiteDescriptor, 1);
                AnnotatedMethodHandle annGetter = this.propertyGetters.get(callSiteDescriptor.getNameToken(2));
                if (annGetter == null) {
                    return this.getGuardedInvocationComponent(callSiteDescriptor, linkerServices, ops);
                }
                MethodHandle getter = annGetter.handle;
                GuardedInvocationComponent.ValidationType validationType = annGetter.validationType;
                return new GuardedInvocationComponent(linkerServices.asType(getter, type), this.getGuard(validationType, type), this.clazz, validationType);
            }
        }
        return null;
    }

    private MethodHandle getGuard(GuardedInvocationComponent.ValidationType validationType, MethodType methodType) {
        switch (validationType) {
            case EXACT_CLASS: {
                return this.getClassGuard(methodType);
            }
            case INSTANCE_OF: {
                return this.getAssignableGuard(methodType);
            }
            case IS_ARRAY: {
                return Guards.isArray(0, methodType);
            }
            case NONE: {
                return null;
            }
        }
        throw new AssertionError();
    }

    private GuardedInvocationComponent getMethodGetter(CallSiteDescriptor callSiteDescriptor, LinkerServices linkerServices, List<String> ops) throws Exception {
        MethodType type = callSiteDescriptor.getMethodType();
        switch (callSiteDescriptor.getNameTokenCount()) {
            case 2: {
                AbstractJavaLinker.assertParameterCount(callSiteDescriptor, 2);
                GuardedInvocationComponent nextComponent = this.getGuardedInvocationComponent(callSiteDescriptor, linkerServices, ops);
                if (nextComponent == null) {
                    return this.getClassGuardedInvocationComponent(linkerServices.asType(this.getDynamicMethod, type), type);
                }
                MethodHandle typedGetter = linkerServices.asType(this.getDynamicMethod, type.changeReturnType(DynamicMethod.class));
                MethodHandle returnMethodHandle = linkerServices.asType(MethodHandles.dropArguments(DYNAMIC_METHOD_IDENTITY, 1, type.parameterList()), type.insertParameterTypes(0, DynamicMethod.class));
                MethodHandle nextComponentInvocation = nextComponent.getGuardedInvocation().getInvocation();
                assert (nextComponentInvocation.type().equals((Object)type));
                MethodHandle nextCombinedInvocation = MethodHandles.dropArguments(nextComponentInvocation, 0, new Class[]{DynamicMethod.class});
                MethodHandle compositeGetter = MethodHandles.foldArguments(MethodHandles.guardWithTest(IS_DYNAMIC_METHOD_NOT_NULL, returnMethodHandle, nextCombinedInvocation), typedGetter);
                return nextComponent.compose(compositeGetter, this.getClassGuard(type), this.clazz, GuardedInvocationComponent.ValidationType.EXACT_CLASS);
            }
            case 3: {
                AbstractJavaLinker.assertParameterCount(callSiteDescriptor, 1);
                DynamicMethod method = this.getDynamicMethod(callSiteDescriptor.getNameToken(2));
                if (method == null) {
                    return this.getGuardedInvocationComponent(callSiteDescriptor, linkerServices, ops);
                }
                return this.getClassGuardedInvocationComponent(linkerServices.asType(MethodHandles.dropArguments(MethodHandles.constant(DynamicMethod.class, method), 0, new Class[]{type.parameterType(0)}), type), type);
            }
        }
        return null;
    }

    private static void assertParameterCount(CallSiteDescriptor descriptor, int paramCount) {
        if (descriptor.getMethodType().parameterCount() != paramCount) {
            throw new BootstrapMethodError(descriptor.getName() + " must have exactly " + paramCount + " parameters.");
        }
    }

    private Object getPropertyGetterHandle(Object id) {
        return this.propertyGetters.get(id);
    }

    private MethodHandle getPropertySetterHandle(MethodType setterType, LinkerServices linkerServices, Object id) {
        return AbstractJavaLinker.getDynamicMethodInvocation(setterType, linkerServices, String.valueOf(id), this.propertySetters);
    }

    private DynamicMethod getDynamicMethod(Object name) {
        return AbstractJavaLinker.getDynamicMethod(String.valueOf(name), this.methods);
    }

    DynamicMethod getDynamicMethod(String name) {
        return AbstractJavaLinker.getDynamicMethod(name, this.methods);
    }

    private static Method getMostGenericGetter(Method getter) {
        return AbstractJavaLinker.getMostGenericGetter(getter.getName(), getter.getReturnType(), getter.getDeclaringClass());
    }

    private static Method getMostGenericGetter(String name, Class<?> returnType, Class<?> declaringClass) {
        if (declaringClass == null) {
            return null;
        }
        for (Class<?> itf : declaringClass.getInterfaces()) {
            Method itfGetter = AbstractJavaLinker.getMostGenericGetter(name, returnType, itf);
            if (itfGetter == null) continue;
            return itfGetter;
        }
        Method superGetter = AbstractJavaLinker.getMostGenericGetter(name, returnType, declaringClass.getSuperclass());
        if (superGetter != null) {
            return superGetter;
        }
        if (!CheckRestrictedPackage.isRestrictedClass(declaringClass)) {
            try {
                return declaringClass.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class AnnotatedMethodHandle {
        final MethodHandle handle;
        final GuardedInvocationComponent.ValidationType validationType;

        AnnotatedMethodHandle(MethodHandle handle, GuardedInvocationComponent.ValidationType validationType) {
            this.handle = handle;
            this.validationType = validationType;
        }
    }
}

