/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.Condition;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.UnaryNode;

final class BranchOptimizer {
    private final CodeGenerator codegen;
    private final MethodEmitter method;

    BranchOptimizer(CodeGenerator codegen, MethodEmitter method) {
        this.codegen = codegen;
        this.method = method;
    }

    void execute(Node node, Label label, boolean state) {
        this.branchOptimizer(node, label, state);
    }

    private void load(Node node) {
        this.codegen.load(node);
    }

    private void branchOptimizer(UnaryNode unaryNode, Label label, boolean state) {
        Node rhs = unaryNode.rhs();
        switch (unaryNode.tokenType()) {
            case NOT: {
                this.branchOptimizer(rhs, label, !state);
                return;
            }
            case CONVERT: {
                if (!unaryNode.getType().isBoolean()) break;
                this.branchOptimizer(rhs, label, state);
                return;
            }
        }
        this.load(unaryNode);
        this.method.convert(Type.BOOLEAN);
        if (state) {
            this.method.ifne(label);
        } else {
            this.method.ifeq(label);
        }
    }

    private void branchOptimizer(BinaryNode binaryNode, Label label, boolean state) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        switch (binaryNode.tokenType()) {
            case AND: {
                if (state) {
                    Label skip = new Label("skip");
                    this.branchOptimizer(lhs, skip, false);
                    this.branchOptimizer(rhs, label, true);
                    this.method.label(skip);
                } else {
                    this.branchOptimizer(lhs, label, false);
                    this.branchOptimizer(rhs, label, false);
                }
                return;
            }
            case OR: {
                if (state) {
                    this.branchOptimizer(lhs, label, true);
                    this.branchOptimizer(rhs, label, true);
                } else {
                    Label skip = new Label("skip");
                    this.branchOptimizer(lhs, skip, true);
                    this.branchOptimizer(rhs, label, false);
                    this.method.label(skip);
                }
                return;
            }
            case EQ: 
            case EQ_STRICT: {
                assert (rhs.getType().isEquivalentTo(lhs.getType())) : "type mismatch: " + lhs.getSymbol() + " to " + rhs.getSymbol();
                this.load(lhs);
                this.load(rhs);
                this.method.conditionalJump(state ? Condition.EQ : Condition.NE, true, label);
                return;
            }
            case NE: 
            case NE_STRICT: {
                assert (rhs.getType().isEquivalentTo(lhs.getType())) : "type mismatch: " + lhs.getSymbol() + " to " + rhs.getSymbol();
                this.load(lhs);
                this.load(rhs);
                this.method.conditionalJump(state ? Condition.NE : Condition.EQ, true, label);
                return;
            }
            case GE: {
                assert (rhs.getType().isEquivalentTo(lhs.getType())) : "type mismatch: " + lhs.getSymbol() + " to " + rhs.getSymbol();
                this.load(lhs);
                this.load(rhs);
                this.method.conditionalJump(state ? Condition.GE : Condition.LT, !state, label);
                return;
            }
            case GT: {
                assert (rhs.getType().isEquivalentTo(lhs.getType())) : "type mismatch: " + lhs.getSymbol() + " to " + rhs.getSymbol();
                this.load(lhs);
                this.load(rhs);
                this.method.conditionalJump(state ? Condition.GT : Condition.LE, !state, label);
                return;
            }
            case LE: {
                assert (rhs.getType().isEquivalentTo(lhs.getType())) : "type mismatch: " + lhs.getSymbol() + " to " + rhs.getSymbol();
                this.load(lhs);
                this.load(rhs);
                this.method.conditionalJump(state ? Condition.LE : Condition.GT, state, label);
                return;
            }
            case LT: {
                assert (rhs.getType().isEquivalentTo(lhs.getType())) : "type mismatch: " + lhs.getSymbol() + " to " + rhs.getSymbol() + " in " + binaryNode;
                this.load(lhs);
                this.load(rhs);
                this.method.conditionalJump(state ? Condition.LT : Condition.GE, state, label);
                return;
            }
        }
        this.load(binaryNode);
        this.method.convert(Type.BOOLEAN);
        if (state) {
            this.method.ifne(label);
        } else {
            this.method.ifeq(label);
        }
    }

    private void branchOptimizer(Node node, Label label, boolean state) {
        if (!(node instanceof TernaryNode)) {
            if (node instanceof BinaryNode) {
                this.branchOptimizer((BinaryNode)node, label, state);
                return;
            }
            if (node instanceof UnaryNode) {
                this.branchOptimizer((UnaryNode)node, label, state);
                return;
            }
        }
        this.load(node);
        this.method.convert(Type.BOOLEAN);
        if (state) {
            this.method.ifne(label);
        } else {
            this.method.ifeq(label);
        }
    }
}

