/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import jdk.internal.dynalink.support.NameCodec;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CompilationPhase;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.ConstantData;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.options.Options;
import jdk.nashorn.internal.scripts.JS$;

public final class Compiler {
    public static final String SCRIPTS_PACKAGE = "jdk/nashorn/internal/scripts";
    public static final String OBJECTS_PACKAGE = "jdk/nashorn/internal/objects";
    static final boolean LAZY_JIT = Options.getBooleanProperty("nashorn.compiler.lazy");
    static final boolean TIME_COMPILATION = Options.getBooleanProperty("nashorn.compiler.time");
    private final Map<String, byte[]> bytecode;
    private final Set<CompileUnit> compileUnits;
    private final ConstantData constantData;
    private final FunctionNode functionNode;
    private final CompilationSequence sequence;
    private final Context context;
    private final String scriptName;
    private boolean strict;
    private CodeInstaller<Context> installer;
    static final DebugLogger LOG = new DebugLogger("compiler");
    private static String[] RESERVED_NAMES = new String[]{CompilerConstants.SCOPE.tag(), CompilerConstants.THIS.tag()};
    static final CompilationSequence SEQUENCE_NORMAL = new CompilationSequence(CompilationPhase.CONSTANT_FOLDING_PHASE, CompilationPhase.LOWERING_PHASE, CompilationPhase.ATTRIBUTION_PHASE, CompilationPhase.SPLITTING_PHASE, CompilationPhase.TYPE_FINALIZATION_PHASE, CompilationPhase.BYTECODE_GENERATION_PHASE);
    static final CompilationSequence SEQUENCE_LAZY = SEQUENCE_NORMAL.insertFirst(CompilationPhase.LAZY_INITIALIZATION_PHASE);
    static final CompilationSequence SEQUENCE_DEFAULT = LAZY_JIT ? SEQUENCE_LAZY : SEQUENCE_NORMAL;
    private static final boolean USE_INT_ARITH = Options.getBooleanProperty("nashorn.compiler.intarithmetic");

    Compiler(Context context, CodeInstaller<Context> installer, FunctionNode functionNode, CompilationSequence sequence, boolean strict) {
        this.context = context;
        this.functionNode = functionNode;
        this.sequence = sequence;
        this.installer = installer;
        this.strict = strict || functionNode.isStrictMode();
        this.constantData = new ConstantData();
        this.compileUnits = new HashSet<CompileUnit>();
        this.bytecode = new HashMap<String, byte[]>();
        StringBuilder sb = new StringBuilder();
        sb.append(functionNode.uniqueName(CompilerConstants.DEFAULT_SCRIPT_NAME.tag())).append('$').append(Compiler.safeSourceName(functionNode.getSource())).append(functionNode.isLazy() ? CompilerConstants.LAZY.tag() : "");
        this.scriptName = sb.toString();
        LOG.info("Initializing compiler for scriptName = " + this.scriptName + ", root function: '" + functionNode.getName() + "'");
    }

    public Compiler(CodeInstaller<Context> installer, FunctionNode functionNode, boolean strict) {
        this(installer.getOwner(), installer, functionNode, SEQUENCE_DEFAULT, strict);
    }

    public Compiler(CodeInstaller<Context> installer, FunctionNode functionNode) {
        this(installer.getOwner(), installer, functionNode, SEQUENCE_DEFAULT, installer.getOwner()._strict);
    }

    public Compiler(Context context, FunctionNode functionNode) {
        this(context, null, functionNode, SEQUENCE_DEFAULT, context._strict);
    }

    public boolean compile() {
        for (String reservedName : RESERVED_NAMES) {
            this.functionNode.uniqueName(reservedName);
        }
        for (CompilationPhase phase : this.sequence) {
            LOG.info("Entering compile phase " + (Object)((Object)phase) + " for function '" + this.functionNode.getName() + "'");
            if (!phase.isApplicable(this.functionNode) || phase.apply(this, this.functionNode)) continue;
            return false;
        }
        return true;
    }

    public Class<?> install() {
        Class<?> rootClass = null;
        for (Map.Entry<String, byte[]> entry : this.bytecode.entrySet()) {
            String className = entry.getKey();
            LOG.info("Installing class " + className);
            byte[] code = entry.getValue();
            Class<?> clazz = this.installer.install(Compiler.binaryName(className), code);
            if (rootClass == null && this.firstCompileUnitName().equals(className)) {
                rootClass = clazz;
            }
            try {
                clazz.getField(CompilerConstants.SOURCE.tag()).set(null, this.getSource());
                clazz.getField(CompilerConstants.CONSTANTS.tag()).set(null, this.getConstantData().toArray());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        LOG.info("Root class: " + rootClass);
        return rootClass;
    }

    Set<CompileUnit> getCompileUnits() {
        return this.compileUnits;
    }

    boolean getStrictMode() {
        return this.strict;
    }

    void setStrictMode(boolean strict) {
        this.strict = strict;
    }

    FunctionNode getFunctionNode() {
        return this.functionNode;
    }

    ConstantData getConstantData() {
        return this.constantData;
    }

    CodeInstaller<Context> getCodeInstaller() {
        return this.installer;
    }

    Source getSource() {
        return this.functionNode.getSource();
    }

    void addClass(String name, byte[] code) {
        this.bytecode.put(name, code);
    }

    Context getContext() {
        return this.context;
    }

    private static String safeSourceName(Source source) {
        String mangled;
        String baseName = new File(source.getName()).getName();
        int index = baseName.lastIndexOf(".js");
        if (index != -1) {
            baseName = baseName.substring(0, index);
        }
        return (mangled = NameCodec.encode(baseName = baseName.replace('.', '_').replace('-', '_'))) != null ? mangled : baseName;
    }

    private int nextCompileUnitIndex() {
        return this.compileUnits.size() + 1;
    }

    String firstCompileUnitName() {
        return "jdk/nashorn/internal/scripts/" + this.scriptName;
    }

    private String nextCompileUnitName() {
        return this.firstCompileUnitName() + '$' + this.nextCompileUnitIndex();
    }

    CompileUnit addCompileUnit(long initialWeight) {
        return this.addCompileUnit(this.nextCompileUnitName(), initialWeight);
    }

    CompileUnit addCompileUnit(String unitClassName) {
        return this.addCompileUnit(unitClassName, 0L);
    }

    private CompileUnit addCompileUnit(String unitClassName, long initialWeight) {
        CompileUnit compileUnit = this.initCompileUnit(unitClassName, initialWeight);
        this.compileUnits.add(compileUnit);
        LOG.info("Added compile unit " + compileUnit);
        return compileUnit;
    }

    private CompileUnit initCompileUnit(String unitClassName, long initialWeight) {
        ClassEmitter classEmitter = new ClassEmitter(this.context, this.functionNode.getSource().getName(), unitClassName, this.strict);
        CompileUnit compileUnit = new CompileUnit(unitClassName, classEmitter, initialWeight);
        classEmitter.begin();
        MethodEmitter initMethod = classEmitter.init(EnumSet.of(ClassEmitter.Flag.PRIVATE), new Class[0]);
        initMethod.begin();
        initMethod.load(Type.OBJECT, 0);
        initMethod.newInstance(JS$.class);
        initMethod.returnVoid();
        initMethod.end();
        return compileUnit;
    }

    CompileUnit findUnit(long weight) {
        for (CompileUnit unit : this.compileUnits) {
            if (!unit.canHold(weight)) continue;
            unit.addWeight(weight);
            return unit;
        }
        return this.addCompileUnit(weight);
    }

    public static String binaryName(String name) {
        return name.replace('/', '.');
    }

    static boolean shouldUseIntegerArithmetic() {
        return USE_INT_ARITH;
    }

    static {
        assert (!USE_INT_ARITH) : "Integer arithmetic is not enabled";
        if (TIME_COMPILATION) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    for (CompilationPhase phase : CompilationPhase.values()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append((Object)phase);
                        while (sb.length() < 32) {
                            sb.append(' ');
                        }
                        sb.append(CompilationPhase.getAccumulatedTime(phase));
                        sb.append(' ');
                        sb.append(" ms");
                        System.err.println(sb.toString());
                    }
                }
            });
        }
    }

    static class CompilationSequence
    extends LinkedList<CompilationPhase> {
        CompilationSequence(CompilationPhase ... phases) {
            super(Arrays.asList(phases));
        }

        CompilationSequence(CompilationSequence sequence) {
            this(sequence.toArray(new CompilationPhase[sequence.size()]));
        }

        CompilationSequence insertAfter(CompilationPhase phase, CompilationPhase newPhase) {
            CompilationSequence newSeq = new CompilationSequence(new CompilationPhase[0]);
            for (CompilationPhase elem : this) {
                newSeq.add(phase);
                if (!elem.equals((Object)phase)) continue;
                newSeq.add(newPhase);
            }
            assert (newSeq.contains((Object)newPhase));
            return newSeq;
        }

        CompilationSequence insertBefore(CompilationPhase phase, CompilationPhase newPhase) {
            CompilationSequence newSeq = new CompilationSequence(new CompilationPhase[0]);
            for (CompilationPhase elem : this) {
                if (elem.equals((Object)phase)) {
                    newSeq.add(newPhase);
                }
                newSeq.add(phase);
            }
            assert (newSeq.contains((Object)newPhase));
            return newSeq;
        }

        CompilationSequence insertFirst(CompilationPhase phase) {
            CompilationSequence newSeq = new CompilationSequence(this);
            newSeq.addFirst(phase);
            return newSeq;
        }

        CompilationSequence insertLast(CompilationPhase phase) {
            CompilationSequence newSeq = new CompilationSequence(this);
            newSeq.addLast(phase);
            return newSeq;
        }
    }
}

