/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.HashSet;
import java.util.List;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.FoldConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.JSType;

final class FinalizeTypes
extends NodeOperatorVisitor {
    private static final DebugLogger LOG = new DebugLogger("finalize");

    FinalizeTypes() {
    }

    @Override
    public Node leave(CallNode callNode) {
        Node function;
        CallNode.EvalArgs evalArgs = callNode.getEvalArgs();
        if (evalArgs != null) {
            evalArgs.setCode(evalArgs.getCode().accept(this));
        }
        if ((function = callNode.getFunction()) instanceof ReferenceNode) {
            FinalizeTypes.setTypeOverride(callNode, ((ReferenceNode)function).getReference().getType());
        }
        return callNode;
    }

    private Node leaveUnary(UnaryNode unaryNode) {
        unaryNode.setRHS(this.convert(unaryNode.rhs(), unaryNode.getType()));
        return unaryNode;
    }

    @Override
    public Node leaveADD(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode);
    }

    @Override
    public Node leaveBIT_NOT(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode);
    }

    @Override
    public Node leaveCONVERT(UnaryNode unaryNode) {
        assert (unaryNode.rhs().tokenType() != TokenType.CONVERT) : "convert(convert encountered. check its origin and remove it";
        return unaryNode;
    }

    @Override
    public Node leaveDECINC(UnaryNode unaryNode) {
        FinalizeTypes.specialize(unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveNEW(UnaryNode unaryNode) {
        assert (unaryNode.getSymbol() != null && unaryNode.getSymbol().getSymbolType().isObject());
        ((CallNode)unaryNode.rhs()).setIsNew();
        return unaryNode;
    }

    @Override
    public Node leaveSUB(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode);
    }

    @Override
    public Node leaveADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type type = binaryNode.getType();
        if (type.isObject() && !this.isAddString(binaryNode)) {
            return new RuntimeNode(binaryNode, RuntimeNode.Request.ADD);
        }
        binaryNode.setLHS(this.convert(lhs, type));
        binaryNode.setRHS(this.convert(rhs, type));
        return binaryNode;
    }

    @Override
    public Node leaveAND(BinaryNode binaryNode) {
        return binaryNode;
    }

    @Override
    public Node leaveASSIGN(BinaryNode binaryNode) {
        Type destType = FinalizeTypes.specialize(binaryNode);
        if (destType == null) {
            destType = binaryNode.getType();
        }
        binaryNode.setRHS(this.convert(binaryNode.rhs(), destType));
        return binaryNode;
    }

    @Override
    public Node leaveASSIGN_ADD(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_DIV(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MOD(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MUL(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SAR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHL(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SUB(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveBIT_AND(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null && binaryNode.getSymbol().getSymbolType().isInteger()) : binaryNode.getSymbol();
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveBIT_OR(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null && binaryNode.getSymbol().getSymbolType().isInteger());
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveBIT_XOR(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null && binaryNode.getSymbol().getSymbolType().isInteger());
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveCOMMALEFT(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null);
        binaryNode.setRHS(FinalizeTypes.discard(binaryNode.rhs()));
        FinalizeTypes.propagateType(binaryNode, binaryNode.lhs().getType());
        return binaryNode;
    }

    @Override
    public Node leaveCOMMARIGHT(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null);
        binaryNode.setLHS(FinalizeTypes.discard(binaryNode.lhs()));
        FinalizeTypes.propagateType(binaryNode, binaryNode.rhs().getType());
        return binaryNode;
    }

    @Override
    public Node leaveDIV(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public Node leaveEQ(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ);
    }

    @Override
    public Node leaveEQ_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ_STRICT);
    }

    @Override
    public Node leaveGE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GE);
    }

    @Override
    public Node leaveGT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GT);
    }

    @Override
    public Node leaveLE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LE);
    }

    @Override
    public Node leaveLT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LT);
    }

    @Override
    public Node leaveMOD(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public Node leaveMUL(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public Node leaveNE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE);
    }

    @Override
    public Node leaveNE_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE_STRICT);
    }

    @Override
    public Node leaveOR(BinaryNode binaryNode) {
        return binaryNode;
    }

    @Override
    public Node leaveSAR(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveSHL(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveSHR(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null && binaryNode.getSymbol().getSymbolType().isLong());
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveSUB(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public Node enter(Block block) {
        FinalizeTypes.updateSymbols(block);
        return block;
    }

    @Override
    public Node leave(CatchNode catchNode) {
        Node exceptionCondition = catchNode.getExceptionCondition();
        if (exceptionCondition != null) {
            catchNode.setExceptionCondition(this.convert(exceptionCondition, Type.BOOLEAN));
        }
        return catchNode;
    }

    @Override
    public Node enter(DoWhileNode doWhileNode) {
        return this.enter((WhileNode)doWhileNode);
    }

    @Override
    public Node leave(DoWhileNode doWhileNode) {
        return this.leave((WhileNode)doWhileNode);
    }

    @Override
    public Node leave(ExecuteNode executeNode) {
        executeNode.setExpression(FinalizeTypes.discard(executeNode.getExpression()));
        return executeNode;
    }

    @Override
    public Node leave(ForNode forNode) {
        Node init = forNode.getInit();
        Node test = forNode.getTest();
        Node modify = forNode.getModify();
        if (forNode.isForIn()) {
            forNode.setModify(this.convert(forNode.getModify(), Type.OBJECT));
            return forNode;
        }
        if (init != null) {
            forNode.setInit(FinalizeTypes.discard(init));
        }
        if (test != null) {
            forNode.setTest(this.convert(test, Type.BOOLEAN));
        } else assert (forNode.hasGoto()) : "forNode " + forNode + " needs goto and is missing it in " + this.getCurrentFunctionNode();
        if (modify != null) {
            forNode.setModify(FinalizeTypes.discard(modify));
        }
        return forNode;
    }

    @Override
    public Node enter(FunctionNode functionNode) {
        if (functionNode.isLazy()) {
            return null;
        }
        if (!functionNode.needsCallee()) {
            functionNode.getCalleeNode().getSymbol().setNeedsSlot(false);
        }
        if (!functionNode.needsScope() && !functionNode.needsParentScope()) {
            functionNode.getScopeNode().getSymbol().setNeedsSlot(false);
        }
        FinalizeTypes.updateSymbols(functionNode);
        return functionNode;
    }

    @Override
    public Node leave(IfNode ifNode) {
        ifNode.setTest(this.convert(ifNode.getTest(), Type.BOOLEAN));
        return ifNode;
    }

    @Override
    public Node enter(LiteralNode literalNode) {
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)literalNode;
            Node[] array = (Node[])arrayLiteralNode.getValue();
            Type elementType = arrayLiteralNode.getElementType();
            for (int i = 0; i < array.length; ++i) {
                Node element = array[i];
                if (element == null) continue;
                array[i] = this.convert(element.accept(this), elementType);
            }
        }
        return null;
    }

    @Override
    public Node leave(ReturnNode returnNode) {
        Node expr = returnNode.getExpression();
        if (expr != null) {
            returnNode.setExpression(this.convert(expr, this.getCurrentFunctionNode().getReturnType()));
        }
        return returnNode;
    }

    @Override
    public Node leave(RuntimeNode runtimeNode) {
        List<Node> args = runtimeNode.getArgs();
        for (Node arg : args) {
            assert (!arg.getType().isUnknown());
        }
        return runtimeNode;
    }

    @Override
    public Node leave(SwitchNode switchNode) {
        Node expression = switchNode.getExpression();
        List<CaseNode> cases = switchNode.getCases();
        boolean allInteger = switchNode.getTag().getSymbolType().isInteger();
        if (!allInteger) {
            switchNode.setExpression(this.convert(expression, Type.OBJECT));
            for (CaseNode caseNode : cases) {
                Node test = caseNode.getTest();
                if (test == null) continue;
                caseNode.setTest(this.convert(test, Type.OBJECT));
            }
        }
        return switchNode;
    }

    @Override
    public Node leave(TernaryNode ternaryNode) {
        ternaryNode.setLHS(this.convert(ternaryNode.lhs(), Type.BOOLEAN));
        return ternaryNode;
    }

    @Override
    public Node leave(ThrowNode throwNode) {
        throwNode.setExpression(this.convert(throwNode.getExpression(), Type.OBJECT));
        return throwNode;
    }

    @Override
    public Node leave(VarNode varNode) {
        Node rhs = varNode.getInit();
        if (rhs != null) {
            Type destType = FinalizeTypes.specialize(varNode);
            if (destType == null) {
                destType = varNode.getType();
            }
            assert (varNode.hasType()) : varNode + " doesn't have a type";
            varNode.setInit(this.convert(rhs, destType));
        }
        return varNode;
    }

    @Override
    public Node leave(WhileNode whileNode) {
        Node test = whileNode.getTest();
        if (test != null) {
            whileNode.setTest(this.convert(test, Type.BOOLEAN));
        }
        return whileNode;
    }

    @Override
    public Node leave(WithNode withNode) {
        withNode.setExpression(this.convert(withNode.getExpression(), Type.OBJECT));
        return withNode;
    }

    private static void updateSymbolsLog(FunctionNode functionNode, Symbol symbol, boolean loseSlot) {
        if (!symbol.isScope()) {
            LOG.finest("updateSymbols: " + symbol + " => scope, because all vars in " + functionNode.getName() + " are in scope");
        }
        if (loseSlot && symbol.hasSlot()) {
            LOG.finest("updateSymbols: " + symbol + " => no slot, because all vars in " + functionNode.getName() + " are in scope");
        }
    }

    private static void updateSymbols(Block block) {
        if (!block.needsScope()) {
            return;
        }
        assert (!(block instanceof FunctionNode) || block.getFunction() == block);
        FunctionNode functionNode = block.getFunction();
        List<Symbol> symbols = block.getFrame().getSymbols();
        boolean allVarsInScope = functionNode.varsInScope();
        boolean isVarArg = functionNode.isVarArg();
        for (Symbol symbol : symbols) {
            if (symbol.isInternal() || symbol.isThis()) continue;
            if (symbol.isVar()) {
                if (allVarsInScope || symbol.isScope()) {
                    FinalizeTypes.updateSymbolsLog(functionNode, symbol, true);
                    symbol.setIsScope();
                    symbol.setNeedsSlot(false);
                    continue;
                }
                assert (symbol.hasSlot()) : symbol + " should have a slot only, no scope";
                continue;
            }
            if (!symbol.isParam() || !allVarsInScope && !isVarArg && !symbol.isScope()) continue;
            FinalizeTypes.updateSymbolsLog(functionNode, symbol, isVarArg);
            symbol.setIsScope();
            symbol.setNeedsSlot(!isVarArg);
        }
    }

    private Node leaveCmp(BinaryNode binaryNode, RuntimeNode.Request request) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type widest = Type.widest(lhs.getType(), rhs.getType());
        boolean newRuntimeNode = false;
        boolean finalized = false;
        switch (request) {
            case EQ_STRICT: 
            case NE_STRICT: {
                if (lhs.getType().isBoolean() == rhs.getType().isBoolean()) break;
                newRuntimeNode = true;
                widest = Type.OBJECT;
                finalized = true;
            }
        }
        if (newRuntimeNode || widest.isObject()) {
            RuntimeNode runtimeNode = new RuntimeNode(binaryNode, request);
            if (finalized) {
                runtimeNode.setIsFinal();
            }
            return runtimeNode;
        }
        binaryNode.setLHS(this.convert(lhs, widest));
        binaryNode.setRHS(this.convert(rhs, widest));
        return binaryNode;
    }

    private static Type binaryArithType(Type lhsType, Type rhsType) {
        if (!Compiler.shouldUseIntegerArithmetic()) {
            return Type.NUMBER;
        }
        return Type.widest(lhsType, rhsType, Type.NUMBER);
    }

    private Node leaveBinaryArith(BinaryNode binaryNode) {
        Type type = FinalizeTypes.binaryArithType(binaryNode.lhs().getType(), binaryNode.rhs().getType());
        return this.leaveBinary(binaryNode, type, type);
    }

    private Node leaveBinary(BinaryNode binaryNode, Type lhsType, Type rhsType) {
        binaryNode.setLHS(this.convert(binaryNode.lhs(), lhsType));
        binaryNode.setRHS(this.convert(binaryNode.rhs(), rhsType));
        return binaryNode;
    }

    private static void setCanBePrimitive(Node node, final Type to) {
        final HashSet exclude = new HashSet();
        node.accept(new NodeVisitor(){

            private void setCanBePrimitive(Symbol symbol) {
                LOG.info("*** can be primitive symbol " + symbol + " " + Debug.id(symbol));
                symbol.setCanBePrimitive(to);
            }

            @Override
            public Node enter(IdentNode identNode) {
                if (!exclude.contains(identNode)) {
                    this.setCanBePrimitive(identNode.getSymbol());
                }
                return null;
            }

            @Override
            public Node enter(AccessNode accessNode) {
                this.setCanBePrimitive(accessNode.getProperty().getSymbol());
                return null;
            }

            @Override
            public Node enter(IndexNode indexNode) {
                exclude.add(indexNode.getBase());
                return indexNode;
            }
        });
    }

    private static Type specialize(Assignment<?> assignment) {
        Node node = (Node)((Object)assignment);
        Object lhs = assignment.getAssignmentDest();
        Node rhs = assignment.getAssignmentSource();
        if (!FinalizeTypes.canHaveCallSiteType(lhs)) {
            return null;
        }
        Type to = node.isSelfModifying() ? node.getWidestOperationType() : rhs.getType();
        if (!FinalizeTypes.isSupportedCallSiteType(to)) {
            return null;
        }
        FinalizeTypes.setTypeOverride(lhs, to);
        FinalizeTypes.propagateType(node, to);
        return to;
    }

    private static boolean canHaveCallSiteType(Node node) {
        return node instanceof TypeOverride && ((TypeOverride)((Object)node)).canHaveCallSiteType();
    }

    private static boolean isSupportedCallSiteType(Type castTo) {
        return castTo.isNumeric();
    }

    private static void setTypeOverride(Node node, Type to) {
        Type from = node.getType();
        if (!node.getType().equals(to)) {
            LOG.info("Changing call override type for '" + node + "' from " + node.getType() + " to " + to);
            if (!to.isObject() && from.isObject()) {
                FinalizeTypes.setCanBePrimitive(node, to);
            }
        }
        LOG.info("Type override for lhs in '" + node + "' => " + to);
        ((TypeOverride)((Object)node)).setType(to);
    }

    private Node convert(Node node, Type to) {
        assert (!to.isUnknown()) : "unknown type for " + node + " class=" + node.getClass();
        assert (node != null) : "node is null";
        assert (node.getSymbol() != null) : "node " + node + " has no symbol!";
        assert (node.tokenType() != TokenType.CONVERT) : "assert convert in convert " + node + " in " + this.getCurrentFunctionNode();
        Type from = ((Node)node).getType();
        if (Type.areEquivalent(from, to)) {
            return node;
        }
        if (from.isObject() && to.isObject()) {
            return node;
        }
        LiteralNode<?> resultNode = node;
        if (node instanceof LiteralNode && !to.isObject()) {
            LiteralNode<?> newNode = new LiteralNodeConstantEvaluator(node, to).eval();
            if (newNode != null) {
                resultNode = newNode;
            }
        } else {
            if (FinalizeTypes.canHaveCallSiteType(node) && FinalizeTypes.isSupportedCallSiteType(to)) {
                FinalizeTypes.setTypeOverride(node, to);
                return resultNode;
            }
            resultNode = new UnaryNode(node.getSource(), Token.recast(node.getToken(), TokenType.CONVERT), node);
        }
        LOG.info("CONVERT('" + node + "', " + to + ") => '" + resultNode + "'");
        this.getCurrentFunctionNode().newTemporary(this.getCurrentBlock().getFrame(), to, resultNode);
        resultNode.copyTerminalFlags(node);
        return resultNode;
    }

    private static Node discard(Node node) {
        node.setDiscard(true);
        if (node.getSymbol() != null) {
            UnaryNode discard = new UnaryNode(node.getSource(), Token.recast(node.getToken(), TokenType.DISCARD), node);
            discard.copyTerminalFlags(node);
            return discard;
        }
        return node;
    }

    private static void propagateType(Node node, Type to) {
        Symbol symbol = node.getSymbol();
        if (symbol.isTemp()) {
            symbol.setTypeOverride(to);
            LOG.info("Type override for temporary in '" + node + "' => " + to);
        }
    }

    private boolean isAddString(Node node) {
        if (node instanceof BinaryNode && node.isTokenType(TokenType.ADD)) {
            BinaryNode binaryNode = (BinaryNode)node;
            Node lhs = binaryNode.lhs();
            Node rhs = binaryNode.rhs();
            return this.isAddString(lhs) || this.isAddString(rhs);
        }
        return node instanceof LiteralNode && ((LiteralNode)node).isString();
    }

    static class LiteralNodeConstantEvaluator
    extends FoldConstants.ConstantEvaluator<LiteralNode<?>> {
        private final Type type;

        LiteralNodeConstantEvaluator(LiteralNode<?> parent, Type type) {
            super(parent);
            this.type = type;
        }

        @Override
        protected LiteralNode<?> eval() {
            Object value = ((LiteralNode)this.parent).getValue();
            LiteralNode<Object> literalNode = null;
            if (this.type.isString()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toString(value));
            } else if (this.type.isBoolean()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toBoolean(value));
            } else if (this.type.isInteger()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toInt32(value));
            } else if (this.type.isLong()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toLong(value));
            } else if (this.type.isNumber() || ((LiteralNode)this.parent).getType().isNumeric() && !((LiteralNode)this.parent).getType().isNumber()) {
                literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toNumber(value));
            }
            if (literalNode != null) {
                literalNode.setSymbol(((LiteralNode)this.parent).getSymbol());
            }
            return literalNode;
        }
    }
}

