/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class AccessNode
extends BaseNode
implements TypeOverride {
    private IdentNode property;
    private boolean hasCallSiteType;

    public AccessNode(Source source, long token, int finish, Node base, IdentNode property) {
        super(source, token, finish, base);
        this.start = base.getStart();
        this.property = property;
        this.property.setIsPropertyName();
    }

    public AccessNode(AccessNode accessNode) {
        this(accessNode, new Node.CopyState());
    }

    protected AccessNode(AccessNode accessNode, Node.CopyState cs) {
        super(accessNode, cs);
        this.property = (IdentNode)cs.existingOrCopy(accessNode.getProperty());
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new AccessNode(this, cs);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        AccessNode accessNode = (AccessNode)other;
        return this.property.equals(accessNode.getProperty());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.property.hashCode();
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.base = this.base.accept(visitor);
            this.property = (IdentNode)this.property.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean needsParen = this.tokenType().needsParens(this.getBase().tokenType(), true);
        if (this.hasCallSiteType) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? "O" : this.getType().getDescriptor());
            sb.append('}');
        }
        if (needsParen) {
            sb.append('(');
        }
        this.base.toString(sb);
        if (needsParen) {
            sb.append(')');
        }
        sb.append('.');
        sb.append(this.property.getName());
    }

    public IdentNode getProperty() {
        return this.property;
    }

    @Override
    public void setType(Type type) {
        if (ObjectClassGenerator.DEBUG_FIELDS && !Type.areEquivalent(this.getSymbol().getSymbolType(), type)) {
            ObjectClassGenerator.LOG.info(this.getClass().getName() + " " + this + " => " + type + " instead of " + this.getType());
        }
        this.property.setType(type);
        this.getSymbol().setTypeOverride(type);
        this.hasCallSiteType = true;
    }

    @Override
    public boolean canHaveCallSiteType() {
        return true;
    }
}

