/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class CaseNode
extends BreakableNode {
    private Node test;
    private Block body;
    private final Label entry;

    public CaseNode(Source source, long token, int finish, Node test, Block body) {
        super(source, token, finish);
        this.test = test;
        this.body = body;
        this.entry = new Label("entry");
    }

    private CaseNode(CaseNode caseNode, Node.CopyState cs) {
        super(caseNode);
        this.test = cs.existingOrCopy(caseNode.test);
        this.body = (Block)cs.existingOrCopy(caseNode.body);
        this.entry = new Label(caseNode.entry);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new CaseNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            if (this.test != null) {
                this.test = this.test.accept(visitor);
            }
            if (this.body != null) {
                this.body = (Block)this.body.accept(visitor);
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.test != null) {
            sb.append("case ");
            this.test.toString(sb);
            sb.append(':');
        } else {
            sb.append("default:");
        }
    }

    public Block getBody() {
        return this.body;
    }

    public Label getEntry() {
        return this.entry;
    }

    public Node getTest() {
        return this.test;
    }

    public void setTest(Node test) {
        this.test = test;
    }
}

