/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir.debug;

import java.util.Arrays;
import java.util.List;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LineNumberNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.JSONParser;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.Parser;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.Source;

public final class JSONWriter
extends NodeVisitor {
    private final StringBuilder buf = new StringBuilder();
    private final boolean includeLocation;

    public static String parse(Context context, String code, String name, boolean includeLoc) {
        Parser parser = new Parser(context, new Source(name, code), new Context.ThrowErrorManager(), context._strict);
        JSONWriter jsonWriter = new JSONWriter(includeLoc);
        try {
            FunctionNode functionNode = parser.parse(CompilerConstants.RUN_SCRIPT.tag());
            functionNode.accept(jsonWriter);
            return jsonWriter.getString();
        }
        catch (ParserException e) {
            e.throwAsEcmaException();
            return null;
        }
    }

    @Override
    protected Node enterDefault(Node node) {
        this.objectStart();
        this.location(node);
        return node;
    }

    @Override
    protected Node leaveDefault(Node node) {
        this.objectEnd();
        return null;
    }

    @Override
    public Node enter(AccessNode accessNode) {
        this.enterDefault(accessNode);
        this.type("MemberExpression");
        this.comma();
        this.property("object");
        accessNode.getBase().accept(this);
        this.comma();
        this.property("property");
        accessNode.getProperty().accept(this);
        this.comma();
        this.property("computed", false);
        return this.leaveDefault(accessNode);
    }

    @Override
    public Node enter(Block block) {
        this.enterDefault(block);
        this.type("BlockStatement");
        this.comma();
        this.array("body", block.getStatements());
        return this.leaveDefault(block);
    }

    private static boolean isLogical(TokenType tt) {
        switch (tt) {
            case AND: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Node enter(BinaryNode binaryNode) {
        this.enterDefault(binaryNode);
        String name = binaryNode.isAssignment() ? "AssignmentExpression" : (JSONWriter.isLogical(binaryNode.tokenType()) ? "LogicalExpression" : "BinaryExpression");
        this.type(name);
        this.comma();
        this.property("operator", binaryNode.tokenType().getName());
        this.comma();
        this.property("left");
        binaryNode.lhs().accept(this);
        this.comma();
        this.property("right");
        binaryNode.rhs().accept(this);
        return this.leaveDefault(binaryNode);
    }

    @Override
    public Node enter(BreakNode breakNode) {
        this.enterDefault(breakNode);
        this.type("BreakStatement");
        this.comma();
        LabelNode label = breakNode.getLabel();
        if (label != null) {
            this.property("label", label.getLabel().getName());
        } else {
            this.property("label");
            this.nullValue();
        }
        return this.leaveDefault(breakNode);
    }

    @Override
    public Node enter(CallNode callNode) {
        this.enterDefault(callNode);
        this.type("CallExpression");
        this.comma();
        this.property("callee");
        callNode.getFunction().accept(this);
        this.comma();
        this.array("arguments", callNode.getArgs());
        return this.leaveDefault(callNode);
    }

    @Override
    public Node enter(CaseNode caseNode) {
        this.enterDefault(caseNode);
        this.type("SwitchCase");
        this.comma();
        Node test = caseNode.getTest();
        this.property("test");
        if (test != null) {
            test.accept(this);
        } else {
            this.nullValue();
        }
        this.comma();
        this.array("consequent", caseNode.getBody().getStatements());
        return this.leaveDefault(caseNode);
    }

    @Override
    public Node enter(CatchNode catchNode) {
        this.enterDefault(catchNode);
        this.type("CatchClause");
        this.comma();
        this.property("param");
        catchNode.getException().accept(this);
        this.comma();
        Node guard = catchNode.getExceptionCondition();
        this.property("guard");
        if (guard != null) {
            guard.accept(this);
        } else {
            this.nullValue();
        }
        this.comma();
        this.property("body");
        catchNode.getBody().accept(this);
        return this.leaveDefault(catchNode);
    }

    @Override
    public Node enter(ContinueNode continueNode) {
        this.enterDefault(continueNode);
        this.type("ContinueStatement");
        this.comma();
        LabelNode label = continueNode.getLabel();
        if (label != null) {
            this.property("label", label.getLabel().getName());
        } else {
            this.property("label");
            this.nullValue();
        }
        return this.leaveDefault(continueNode);
    }

    @Override
    public Node enter(DoWhileNode doWhileNode) {
        this.enterDefault(doWhileNode);
        this.type("DoWhileStatement");
        this.comma();
        this.property("body");
        doWhileNode.getBody().accept(this);
        this.comma();
        this.property("test");
        doWhileNode.getTest().accept(this);
        return this.leaveDefault(doWhileNode);
    }

    @Override
    public Node enter(EmptyNode emptyNode) {
        this.enterDefault(emptyNode);
        this.type("EmptyStatement");
        return this.leaveDefault(emptyNode);
    }

    @Override
    public Node enter(ExecuteNode executeNode) {
        this.enterDefault(executeNode);
        this.type("ExpressionStatement");
        this.comma();
        this.property("expression");
        executeNode.getExpression().accept(this);
        return this.leaveDefault(executeNode);
    }

    @Override
    public Node enter(ForNode forNode) {
        this.enterDefault(forNode);
        if (forNode.isForIn() || forNode.isForEach()) {
            this.type("ForInStatement");
            this.comma();
            this.property("left");
            forNode.getInit().accept(this);
            this.comma();
            this.property("right");
            forNode.getModify().accept(this);
            this.comma();
            this.property("body");
            forNode.getBody().accept(this);
            this.comma();
            this.property("each", forNode.isForEach());
        } else {
            this.type("ForStatement");
            this.comma();
            Node init = forNode.getInit();
            this.property("init");
            if (init != null) {
                init.accept(this);
            } else {
                this.nullValue();
            }
            this.comma();
            Node test = forNode.getTest();
            this.property("test");
            if (test != null) {
                test.accept(this);
            } else {
                this.nullValue();
            }
            this.comma();
            Node update = forNode.getModify();
            this.property("update");
            if (update != null) {
                update.accept(this);
            } else {
                this.nullValue();
            }
            this.comma();
            this.property("body");
            forNode.getBody().accept(this);
        }
        return this.leaveDefault(forNode);
    }

    @Override
    public Node enter(FunctionNode functionNode) {
        this.enterDefault(functionNode);
        boolean program = functionNode.isScript();
        String name = program ? "Program" : (functionNode.isStatement() ? "FunctionDeclaration" : "FunctionExpression");
        this.type(name);
        this.comma();
        if (!program) {
            this.property("id");
            if (functionNode.isAnonymous()) {
                this.nullValue();
            } else {
                functionNode.getIdent().accept(this);
            }
            this.comma();
        }
        this.property("rest");
        this.nullValue();
        this.comma();
        if (!program) {
            this.array("params", functionNode.getParameters());
            this.comma();
        }
        List<FunctionNode> funcs = functionNode.getFunctions();
        List<Node> stats = functionNode.getStatements();
        int size = stats.size() + funcs.size();
        int idx = 0;
        this.arrayStart("body");
        for (Node node : funcs) {
            node.accept(this);
            if (idx != size - 1) {
                this.comma();
            }
            ++idx;
        }
        for (Node node : stats) {
            if (!node.isDebug()) {
                node.accept(this);
                if (idx != size - 1) {
                    this.comma();
                }
            }
            ++idx;
        }
        this.arrayEnd();
        return this.leaveDefault(functionNode);
    }

    @Override
    public Node enter(IdentNode identNode) {
        this.enterDefault(identNode);
        String name = identNode.getName();
        if ("this".equals(name)) {
            this.type("ThisExpression");
        } else {
            this.type("Identifier");
            this.comma();
            this.property("name", identNode.getName());
        }
        return this.leaveDefault(identNode);
    }

    @Override
    public Node enter(IfNode ifNode) {
        this.enterDefault(ifNode);
        this.type("IfStatement");
        this.comma();
        this.property("test");
        ifNode.getTest().accept(this);
        this.comma();
        this.property("consequent");
        ifNode.getPass().accept(this);
        Block elsePart = ifNode.getFail();
        this.comma();
        this.property("alternate");
        if (elsePart != null) {
            ((Node)elsePart).accept(this);
        } else {
            this.nullValue();
        }
        return this.leaveDefault(ifNode);
    }

    @Override
    public Node enter(IndexNode indexNode) {
        this.enterDefault(indexNode);
        this.type("MemberExpression");
        this.comma();
        this.property("object");
        indexNode.getBase().accept(this);
        this.comma();
        this.property("property");
        indexNode.getIndex().accept(this);
        this.comma();
        this.property("computed", true);
        return this.leaveDefault(indexNode);
    }

    @Override
    public Node enter(LabelNode labelNode) {
        this.enterDefault(labelNode);
        this.type("LabeledStatement");
        this.comma();
        this.property("label");
        labelNode.getLabel().accept(this);
        this.comma();
        this.property("body");
        labelNode.getBody().accept(this);
        return this.leaveDefault(labelNode);
    }

    @Override
    public Node enter(LineNumberNode lineNumberNode) {
        return null;
    }

    @Override
    public Node enter(LiteralNode literalNode) {
        this.enterDefault(literalNode);
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            this.type("ArrayExpression");
            this.comma();
            Node[] value = (Node[])literalNode.getValue();
            this.array("elements", Arrays.asList(value));
        } else {
            this.type("Literal");
            this.comma();
            this.property("value");
            Object value = literalNode.getValue();
            if (value instanceof Lexer.RegexToken) {
                Lexer.RegexToken regex = (Lexer.RegexToken)value;
                StringBuilder regexBuf = new StringBuilder();
                regexBuf.append('/');
                regexBuf.append(regex.getExpression());
                regexBuf.append('/');
                regexBuf.append(regex.getOptions());
                this.buf.append(JSONWriter.quote(regexBuf.toString()));
            } else {
                String str = literalNode.getString();
                this.buf.append(literalNode.isString() ? JSONWriter.quote("$" + str) : str);
            }
        }
        return this.leaveDefault(literalNode);
    }

    @Override
    public Node enter(ObjectNode objectNode) {
        this.enterDefault(objectNode);
        this.type("ObjectExpression");
        this.comma();
        this.array("properties", objectNode.getElements());
        return this.leaveDefault(objectNode);
    }

    @Override
    public Node enter(PropertyNode propertyNode) {
        Node key = propertyNode.getKey();
        Node value = propertyNode.getValue();
        if (value != null) {
            this.objectStart();
            this.location(propertyNode);
            this.property("key");
            key.accept(this);
            this.comma();
            this.property("value");
            value.accept(this);
            this.comma();
            this.property("kind", "init");
            this.objectEnd();
        } else {
            Node setter;
            Node getter = propertyNode.getGetter();
            if (getter != null) {
                this.objectStart();
                this.location(propertyNode);
                this.property("key");
                key.accept(this);
                this.comma();
                this.property("value");
                getter.accept(this);
                this.comma();
                this.property("kind", "get");
                this.objectEnd();
            }
            if ((setter = propertyNode.getSetter()) != null) {
                this.objectStart();
                this.location(propertyNode);
                this.property("key");
                key.accept(this);
                this.comma();
                this.property("value");
                setter.accept(this);
                this.comma();
                this.property("kind", "set");
                this.objectEnd();
            }
        }
        return null;
    }

    @Override
    public Node enter(ReturnNode returnNode) {
        this.enterDefault(returnNode);
        this.type("ReturnStatement");
        this.comma();
        Node arg = returnNode.getExpression();
        this.property("argument");
        if (arg != null) {
            arg.accept(this);
        } else {
            this.nullValue();
        }
        return this.leaveDefault(returnNode);
    }

    @Override
    public Node enter(RuntimeNode runtimeNode) {
        RuntimeNode.Request req = runtimeNode.getRequest();
        if (req == RuntimeNode.Request.DEBUGGER) {
            this.enterDefault(runtimeNode);
            this.type("DebuggerStatement");
            return this.leaveDefault(runtimeNode);
        }
        return null;
    }

    @Override
    public Node enter(SplitNode splitNode) {
        return null;
    }

    @Override
    public Node enter(SwitchNode switchNode) {
        this.enterDefault(switchNode);
        this.type("SwitchStatement");
        this.comma();
        this.property("discriminant");
        switchNode.getExpression().accept(this);
        this.comma();
        this.array("cases", switchNode.getCases());
        return this.leaveDefault(switchNode);
    }

    @Override
    public Node enter(TernaryNode ternaryNode) {
        this.enterDefault(ternaryNode);
        this.type("ConditionalExpression");
        this.comma();
        this.property("test");
        ternaryNode.lhs().accept(this);
        this.comma();
        this.property("consequent");
        ternaryNode.rhs().accept(this);
        this.comma();
        this.property("alternate");
        ternaryNode.third().accept(this);
        return this.leaveDefault(ternaryNode);
    }

    @Override
    public Node enter(ThrowNode throwNode) {
        this.enterDefault(throwNode);
        this.type("ThrowStatement");
        this.comma();
        this.property("argument");
        throwNode.getExpression().accept(this);
        return this.leaveDefault(throwNode);
    }

    @Override
    public Node enter(TryNode tryNode) {
        this.enterDefault(tryNode);
        this.type("TryStatement");
        this.comma();
        this.property("block");
        tryNode.getBody().accept(this);
        this.comma();
        this.array("handlers", tryNode.getCatches());
        this.comma();
        this.property("finalizer");
        Block finallyNode = tryNode.getFinallyBody();
        if (finallyNode != null) {
            ((Node)finallyNode).accept(this);
        } else {
            this.nullValue();
        }
        return this.leaveDefault(tryNode);
    }

    @Override
    public Node enter(UnaryNode unaryNode) {
        this.enterDefault(unaryNode);
        TokenType tokenType = unaryNode.tokenType();
        if (tokenType == TokenType.NEW) {
            this.type("NewExpression");
            this.comma();
            CallNode callNode = (CallNode)unaryNode.rhs();
            this.property("callee");
            callNode.getFunction().accept(this);
            this.comma();
            this.array("arguments", callNode.getArgs());
        } else {
            String operator;
            boolean prefix;
            switch (tokenType) {
                case DECPOSTFIX: {
                    prefix = false;
                    operator = "++";
                    break;
                }
                case INCPOSTFIX: {
                    prefix = false;
                    operator = "--";
                    break;
                }
                case INCPREFIX: {
                    operator = "++";
                    prefix = true;
                    break;
                }
                case DECPREFIX: {
                    operator = "--";
                    prefix = true;
                    break;
                }
                default: {
                    prefix = false;
                    operator = tokenType.getName();
                }
            }
            this.type(unaryNode.isAssignment() ? "UpdateExpression" : "UnaryExpression");
            this.comma();
            this.property("operator", operator);
            this.comma();
            this.property("prefix", prefix);
            this.comma();
            this.property("argument");
            unaryNode.rhs().accept(this);
        }
        return this.leaveDefault(unaryNode);
    }

    @Override
    public Node enter(VarNode varNode) {
        this.enterDefault(varNode);
        this.type("VariableDeclaration");
        this.comma();
        this.arrayStart("declarations");
        this.objectStart();
        this.location(varNode.getName());
        this.type("VariableDeclarator");
        this.comma();
        this.property("id", varNode.getName().toString());
        this.comma();
        this.property("init");
        Node init = varNode.getInit();
        if (init != null) {
            init.accept(this);
        } else {
            this.nullValue();
        }
        this.objectEnd();
        this.arrayEnd();
        return this.leaveDefault(varNode);
    }

    @Override
    public Node enter(WhileNode whileNode) {
        this.enterDefault(whileNode);
        this.type("WhileStatement");
        this.comma();
        this.property("test");
        whileNode.getTest().accept(this);
        this.comma();
        this.property("block");
        whileNode.getBody().accept(this);
        return this.leaveDefault(whileNode);
    }

    @Override
    public Node enter(WithNode withNode) {
        this.enterDefault(withNode);
        this.type("WithStatement");
        this.comma();
        this.property("object");
        withNode.getExpression().accept(this);
        this.comma();
        this.property("body");
        withNode.getBody().accept(this);
        return this.leaveDefault(withNode);
    }

    private JSONWriter(boolean includeLocation) {
        this.includeLocation = includeLocation;
    }

    private String getString() {
        return this.buf.toString();
    }

    private void property(String key, String value) {
        this.buf.append('\"');
        this.buf.append(key);
        this.buf.append("\":");
        if (value != null) {
            this.buf.append('\"');
            this.buf.append(value);
            this.buf.append('\"');
        }
    }

    private void property(String key, boolean value) {
        this.property(key, Boolean.toString(value));
    }

    private void property(String key, int value) {
        this.property(key, Integer.toString(value));
    }

    private void property(String key) {
        this.property(key, null);
    }

    private void type(String value) {
        this.property("type", value);
    }

    private void objectStart(String name) {
        this.buf.append('\"');
        this.buf.append(name);
        this.buf.append("\":{");
    }

    private void objectStart() {
        this.buf.append('{');
    }

    private void objectEnd() {
        this.buf.append('}');
    }

    private void array(String name, List<? extends Node> nodes) {
        int size = nodes.size();
        int idx = 0;
        this.arrayStart(name);
        for (Node node : nodes) {
            if (!node.isDebug()) {
                node.accept(this);
                if (idx != size - 1) {
                    this.comma();
                }
            }
            ++idx;
        }
        this.arrayEnd();
    }

    private void arrayStart(String name) {
        this.buf.append('\"');
        this.buf.append(name);
        this.buf.append('\"');
        this.buf.append(':');
        this.buf.append('[');
    }

    private void arrayEnd() {
        this.buf.append(']');
    }

    private void comma() {
        this.buf.append(',');
    }

    private void nullValue() {
        this.buf.append("null");
    }

    private void location(Node node) {
        if (this.includeLocation) {
            this.objectStart("loc");
            Source src = node.getSource();
            this.property("source", src.getName());
            this.comma();
            this.objectStart("start");
            int start = node.getStart();
            this.property("line", src.getLine(start));
            this.comma();
            this.property("column", src.getColumn(start));
            this.objectEnd();
            this.comma();
            this.objectStart("end");
            int end = node.getFinish();
            this.property("line", src.getLine(end));
            this.comma();
            this.property("column", src.getColumn(end));
            this.objectEnd();
            this.objectEnd();
            this.comma();
        }
    }

    private static String quote(String str) {
        return JSONParser.quote(str);
    }
}

