/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Logging;
import jdk.nashorn.internal.runtime.options.Options;

public final class DebugLogger {
    private final Logger logger;
    private final boolean isEnabled;
    private int indent;
    private static final int INDENT_SPACE = 4;

    public DebugLogger(String loggerName) {
        this(loggerName, null);
    }

    public DebugLogger(String loggerName, String property) {
        this.logger = property != null && Options.getBooleanProperty(property) ? Logging.getOrCreateLogger(loggerName, Level.INFO) : Logging.getLogger(loggerName);
        this.isEnabled = this.logger.getLevel() != Level.OFF;
    }

    public PrintWriter getOutputStream() {
        return Context.getCurrentErr();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void indent(int pos) {
        if (this.isEnabled) {
            this.indent += pos * 4;
        }
    }

    public void indent() {
        this.indent += 4;
    }

    public void unindent() {
        this.indent -= 4;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    public boolean levelAbove(Level level) {
        return this.logger.getLevel().intValue() > level.intValue();
    }

    public void finest(String str) {
        this.log(str, Level.FINEST);
    }

    public void finer(String str) {
        this.log(str, Level.FINER);
    }

    public void fine(String str) {
        this.log(str, Level.FINE);
    }

    public void config(String str) {
        this.log(str, Level.CONFIG);
    }

    public void info(String str) {
        this.log(str, Level.INFO);
    }

    public void warning(String str) {
        this.log(str, Level.WARNING);
    }

    public void severe(String str) {
        this.log(str, Level.SEVERE);
    }

    public void log(String str, Level level) {
        if (this.isEnabled) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.indent; ++i) {
                sb.append(' ');
            }
            sb.append(str);
            this.logger.log(level, sb.toString());
        }
    }
}

