/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.parser.JSONParser;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.Bootstrap;

public final class JSONFunctions {
    private static final MethodHandle REVIVER_INVOKER = Bootstrap.createDynamicInvoker("dyn:call", Object.class, ScriptFunction.class, ScriptObject.class, String.class, Object.class);

    private JSONFunctions() {
    }

    public static String quote(String str) {
        return JSONParser.quote(str);
    }

    public static Object parse(Object text, Object reviver) {
        Node node;
        String str = JSType.toString(text);
        Context context = Context.getContextTrusted();
        JSONParser parser = new JSONParser(new Source("<json>", str), new Context.ThrowErrorManager(), context != null ? context._strict : false);
        try {
            node = parser.parse();
        }
        catch (ParserException e) {
            ECMAErrors.syntaxError(e, "invalid.json", e.getMessage());
            return ScriptRuntime.UNDEFINED;
        }
        ScriptObject global = Context.getGlobalTrusted();
        Object unfiltered = JSONFunctions.convertNode(global, node);
        return JSONFunctions.applyReviver(global, unfiltered, reviver);
    }

    private static Object applyReviver(ScriptObject global, Object unfiltered, Object reviver) {
        if (reviver instanceof ScriptFunction) {
            assert (global instanceof GlobalObject);
            ScriptObject root = ((GlobalObject)((Object)global)).newObject();
            root.set((Object)"", unfiltered, root.isStrictContext());
            return JSONFunctions.walk(root, "", (ScriptFunction)reviver);
        }
        return unfiltered;
    }

    private static Object walk(ScriptObject holder, Object name, ScriptFunction reviver) {
        Object val = holder.get(name);
        if (val == ScriptRuntime.UNDEFINED) {
            return val;
        }
        if (val instanceof ScriptObject) {
            ScriptObject valueObj = (ScriptObject)val;
            boolean strict = valueObj.isStrictContext();
            Iterator<String> iter = valueObj.propertyIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                Object newElement = JSONFunctions.walk(valueObj, key, reviver);
                if (newElement == ScriptRuntime.UNDEFINED) {
                    valueObj.delete(key, strict);
                    continue;
                }
                valueObj.set((Object)key, newElement, strict);
            }
            return valueObj;
        }
        if (ScriptObject.isArray(val)) {
            ScriptObject valueArray = (ScriptObject)val;
            boolean strict = valueArray.isStrictContext();
            Iterator<String> iter = valueArray.propertyIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                Object newElement = JSONFunctions.walk(valueArray, valueArray.get(key), reviver);
                if (newElement == ScriptRuntime.UNDEFINED) {
                    valueArray.delete(key, strict);
                    continue;
                }
                valueArray.set((Object)key, newElement, strict);
            }
            return valueArray;
        }
        try {
            return REVIVER_INVOKER.invokeExact(reviver, holder, JSType.toString(name), val);
        }
        catch (Error | RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static Object convertNode(ScriptObject global, Node node) {
        assert (global instanceof GlobalObject);
        if (node instanceof LiteralNode) {
            if (node.tokenType() == TokenType.ARRAY) {
                assert (node instanceof LiteralNode.ArrayLiteralNode);
                Node[] elements = (Node[])((LiteralNode.ArrayLiteralNode)node).getValue();
                if (JSONFunctions.isNumericArray(elements)) {
                    double[] values = new double[elements.length];
                    int index = 0;
                    for (Node elem : elements) {
                        values[index++] = JSType.toNumber(JSONFunctions.convertNode(global, elem));
                    }
                    return ((GlobalObject)((Object)global)).wrapAsObject(values);
                }
                Object[] values = new Object[elements.length];
                int index = 0;
                for (Node elem : elements) {
                    values[index++] = JSONFunctions.convertNode(global, elem);
                }
                return ((GlobalObject)((Object)global)).wrapAsObject(values);
            }
            return ((LiteralNode)node).getValue();
        }
        if (node instanceof ObjectNode) {
            ObjectNode objNode = (ObjectNode)node;
            ScriptObject object = ((GlobalObject)((Object)global)).newObject();
            boolean strict = global.isStrictContext();
            List<Node> elements = objNode.getElements();
            for (Node elem : elements) {
                PropertyNode pNode = (PropertyNode)elem;
                Node valueNode = pNode.getValue();
                object.set((Object)pNode.getKeyName(), JSONFunctions.convertNode(global, valueNode), strict);
            }
            return object;
        }
        if (node instanceof UnaryNode) {
            UnaryNode unaryNode = (UnaryNode)node;
            return -((LiteralNode)unaryNode.rhs()).getNumber();
        }
        return null;
    }

    private static boolean isNumericArray(Node[] values) {
        for (Node node : values) {
            if (node instanceof LiteralNode && ((LiteralNode)node).getValue() instanceof Number) continue;
            return false;
        }
        return true;
    }
}

