/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornGuards;

public abstract class ScriptFunction
extends ScriptObject {
    public static final MethodHandle G$PROTOTYPE = ScriptFunction.findOwnMH("G$prototype", Object.class, Object.class);
    public static final MethodHandle S$PROTOTYPE = ScriptFunction.findOwnMH("S$prototype", Void.TYPE, Object.class, Object.class);
    public static final MethodHandle G$LENGTH = ScriptFunction.findOwnMH("G$length", Integer.TYPE, Object.class);
    public static final MethodHandle G$NAME = ScriptFunction.findOwnMH("G$name", Object.class, Object.class);
    static final MethodHandle ALLOCATE = ScriptFunction.findOwnMH("allocate", Object.class, new Class[0]);
    private static final MethodHandle WRAPFILTER = ScriptFunction.findOwnMH("wrapFilter", Object.class, Object.class);
    public static final CompilerConstants.Call GET_SCOPE = CompilerConstants.virtualCallNoLookup(ScriptFunction.class, "getScope", ScriptObject.class, new Class[0]);
    private final ScriptFunctionData data;
    protected Object prototype;
    private final ScriptObject scope;
    private static int constructorCount;
    private static int invokes;
    private static int allocations;

    protected ScriptFunction(String name, MethodHandle methodHandle, PropertyMap map, ScriptObject scope, MethodHandle[] specs, boolean strict, boolean builtin, boolean isConstructor) {
        this(new ScriptFunctionData(name, methodHandle, specs, strict, builtin, isConstructor), map, scope);
    }

    protected ScriptFunction(ScriptFunctionData data, PropertyMap map, ScriptObject scope) {
        super(map);
        if (Context.DEBUG) {
            ++constructorCount;
        }
        this.data = data;
        this.scope = scope;
    }

    @Override
    public String getClassName() {
        return "Function";
    }

    @Override
    public boolean isInstance(ScriptObject instance) {
        Object basePrototype = this.getTargetFunction().getPrototype();
        if (!(basePrototype instanceof ScriptObject)) {
            ECMAErrors.typeError("prototype.not.an.object", ScriptRuntime.safeToString(this.getTargetFunction()), ScriptRuntime.safeToString(basePrototype));
        }
        for (ScriptObject proto = instance.getProto(); proto != null; proto = proto.getProto()) {
            if (proto != basePrototype) continue;
            return true;
        }
        return false;
    }

    protected ScriptFunction getTargetFunction() {
        return this;
    }

    boolean isBoundFunction() {
        return this.getTargetFunction() != this;
    }

    public final void setArity(int arity) {
        this.data.setArity(arity);
    }

    public boolean isStrict() {
        return this.data.isStrict();
    }

    public boolean needsWrappedThis() {
        return this.data.needsWrappedThis();
    }

    Object invoke(Object self, Object ... arguments) throws Throwable {
        if (Context.DEBUG) {
            ++invokes;
        }
        return this.data.invoke(this, self, arguments);
    }

    private Object allocate() {
        if (Context.DEBUG) {
            ++allocations;
        }
        assert (!this.isBoundFunction());
        ScriptObject object = this.data.allocate();
        if (object != null) {
            if (this.prototype instanceof ScriptObject) {
                object.setProto((ScriptObject)this.prototype);
            }
            if (object.getProto() == null) {
                object.setProto(this.getObjectPrototype());
            }
        }
        return object;
    }

    protected abstract ScriptObject getObjectPrototype();

    protected ScriptFunction makeBoundFunction(Object self, Object[] args) {
        return this.makeBoundFunction(this.data.makeBoundFunctionData(this, self, args));
    }

    protected abstract ScriptFunction makeBoundFunction(ScriptFunctionData var1);

    @Override
    public final String safeToString() {
        return this.toSource();
    }

    public String toString() {
        return this.data.toString();
    }

    public final String toSource() {
        return this.data.toSource();
    }

    public final Object getPrototype() {
        return this.prototype;
    }

    public final Object setPrototype(Object prototype) {
        this.prototype = prototype;
        return prototype;
    }

    private final MethodHandle getBestInvoker(MethodType type) {
        return this.data.getBestInvoker(type);
    }

    public final MethodHandle getInvokeHandle() {
        return this.data.getInvoker();
    }

    public final MethodHandle getBoundInvokeHandle(ScriptObject self) {
        return Lookup.MH.bindTo(this.bindToCalleeIfNeeded(this.getInvokeHandle()), self);
    }

    private MethodHandle bindToCalleeIfNeeded(MethodHandle methodHandle) {
        return this.data.needsCallee() ? Lookup.MH.bindTo(methodHandle, this) : methodHandle;
    }

    public final String getName() {
        return this.data.getName();
    }

    public final boolean needsCompilation() {
        return this.data.getInvoker() == null;
    }

    public final ScriptObject getScope() {
        return this.scope;
    }

    protected void resetInvoker(MethodHandle invoker) {
        this.data.resetInvoker(invoker);
    }

    public static Object G$prototype(Object self) {
        return self instanceof ScriptFunction ? ((ScriptFunction)self).getPrototype() : ScriptRuntime.UNDEFINED;
    }

    public static void S$prototype(Object self, Object prototype) {
        if (self instanceof ScriptFunction) {
            ((ScriptFunction)self).setPrototype(prototype);
        }
    }

    public static int G$length(Object self) {
        if (self instanceof ScriptFunction) {
            return ((ScriptFunction)self).data.getArity();
        }
        return 0;
    }

    public static Object G$name(Object self) {
        if (self instanceof ScriptFunction) {
            return ((ScriptFunction)self).getName();
        }
        return ScriptRuntime.UNDEFINED;
    }

    public static ScriptObject getPrototype(Object constructor) {
        Object proto;
        if (constructor instanceof ScriptFunction && (proto = ((ScriptFunction)constructor).getPrototype()) instanceof ScriptObject) {
            return (ScriptObject)proto;
        }
        return null;
    }

    public static int getConstructorCount() {
        return constructorCount;
    }

    public static int getInvokes() {
        return invokes;
    }

    public static int getAllocations() {
        return allocations;
    }

    @Override
    protected GuardedInvocation findNewMethod(CallSiteDescriptor desc) {
        MethodType type = desc.getMethodType();
        return new GuardedInvocation(ScriptFunction.pairArguments(this.data.getBestConstructor(type), type), null, NashornGuards.getFunctionGuard(this));
    }

    private static Object wrapFilter(Object obj) {
        if (obj instanceof ScriptObject || !ScriptFunctionData.isPrimitiveThis(obj)) {
            return obj;
        }
        return ((GlobalObject)((Object)Context.getGlobalTrusted())).wrapAsObject(obj);
    }

    @Override
    protected GuardedInvocation findCallMethod(CallSiteDescriptor desc, LinkRequest request) {
        MethodHandle boundHandle;
        MethodType type = desc.getMethodType();
        if (request.isCallSiteUnstable()) {
            MethodHandle collector = Lookup.MH.asCollector(ScriptRuntime.APPLY.methodHandle(), Object[].class, type.parameterCount() - 2);
            return new GuardedInvocation(collector, ScriptFunction.class.isAssignableFrom((Class<?>)desc.getMethodType().parameterType(0)) ? null : NashornGuards.getScriptFunctionGuard());
        }
        MethodHandle guard = null;
        if (this.data.needsCallee()) {
            MethodHandle callHandle = this.getBestInvoker(type);
            if (NashornCallSiteDescriptor.isScope(desc)) {
                boundHandle = Lookup.MH.insertArguments(callHandle, 1, this.needsWrappedThis() ? Context.getGlobalTrusted() : ScriptRuntime.UNDEFINED);
                boundHandle = Lookup.MH.dropArguments(boundHandle, 1, Object.class);
            } else {
                boundHandle = callHandle;
                if (this.needsWrappedThis()) {
                    if (ScriptFunctionData.isPrimitiveThis(request.getArguments()[1])) {
                        boundHandle = Lookup.MH.filterArguments(boundHandle, 1, WRAPFILTER);
                    } else {
                        guard = NashornGuards.getNonStrictFunctionGuard(this);
                    }
                }
            }
        } else {
            MethodHandle callHandle = this.getBestInvoker(type.dropParameterTypes(0, 1));
            if (NashornCallSiteDescriptor.isScope(desc)) {
                boundHandle = Lookup.MH.bindTo(callHandle, this.needsWrappedThis() ? Context.getGlobalTrusted() : ScriptRuntime.UNDEFINED);
                boundHandle = Lookup.MH.dropArguments(boundHandle, 0, Object.class, Object.class);
            } else {
                boundHandle = Lookup.MH.dropArguments(callHandle, 0, Object.class);
            }
        }
        boundHandle = ScriptFunction.pairArguments(boundHandle, type);
        return new GuardedInvocation(boundHandle, guard == null ? NashornGuards.getFunctionGuard(this) : guard);
    }

    MethodHandle getCallMethodHandle(MethodType type, String bindName) {
        return ScriptFunction.pairArguments(ScriptFunction.bindToNameIfNeeded(this.bindToCalleeIfNeeded(this.getBestInvoker(type)), bindName), type);
    }

    private static MethodHandle bindToNameIfNeeded(MethodHandle methodHandle, String bindName) {
        return bindName == null ? methodHandle : Lookup.MH.insertArguments(methodHandle, 1, bindName);
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        Class<ScriptFunction> own = ScriptFunction.class;
        MethodType mt = Lookup.MH.type(rtype, types);
        try {
            return Lookup.MH.findStatic(MethodHandles.lookup(), own, name, mt);
        }
        catch (MethodHandleFactory.LookupException e) {
            return Lookup.MH.findVirtual(MethodHandles.lookup(), own, name, mt);
        }
    }
}

