/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.StringTokenizer;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.linker.Lookup;

public final class ScriptingFunctions {
    public static final MethodHandle READLINE = ScriptingFunctions.findOwnMH("readLine", Object.class, Object.class);
    public static final MethodHandle READFULLY = ScriptingFunctions.findOwnMH("readFully", Object.class, Object.class, Object.class);
    public static final MethodHandle EXEC = ScriptingFunctions.findOwnMH("exec", Object.class, Object.class, Object.class, Object.class);
    public static final String EXEC_NAME = "$EXEC";
    public static final String OUT_NAME = "$OUT";
    public static final String ERR_NAME = "$ERR";
    public static final String EXIT_NAME = "$EXIT";
    public static final String ENV_NAME = "$ENV";
    private static final String PWD_NAME = "PWD";

    private ScriptingFunctions() {
    }

    public static Object readLine(Object self) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        return reader.readLine();
    }

    public static Object readFully(Object self, Object file) throws IOException {
        File f = null;
        if (file instanceof File) {
            f = (File)file;
        } else if (file instanceof String) {
            f = new File((String)file);
        }
        if (f == null || !f.isFile()) {
            ECMAErrors.typeError("not.a.file", ScriptRuntime.safeToString(file));
            return ScriptRuntime.UNDEFINED;
        }
        return new String(Source.readFully(f));
    }

    public static Object exec(Object self, Object string, Object input) throws IOException, InterruptedException {
        String err;
        String out;
        Object environment;
        ScriptObject global = Context.getGlobal();
        StringTokenizer tokenizer = new StringTokenizer(JSType.toString(string));
        String[] cmdArray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdArray[i] = tokenizer.nextToken();
            ++i;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmdArray);
        Object env = global.get(ENV_NAME);
        if (env instanceof ScriptObject) {
            ScriptObject envProperties = (ScriptObject)env;
            Object pwd = envProperties.get(PWD_NAME);
            if (pwd != ScriptRuntime.UNDEFINED) {
                processBuilder.directory(new File(JSType.toString(pwd)));
            }
            environment = processBuilder.environment();
            environment.clear();
            for (Map.Entry<Object, Object> entry : envProperties.entrySet()) {
                environment.put(JSType.toString(entry.getKey()), JSType.toString(entry.getValue()));
            }
        }
        Process process = processBuilder.start();
        OutputStream outputStream = process.getOutputStream();
        environment = null;
        try {
            if (input != ScriptRuntime.UNDEFINED) {
                outputStream.write(JSType.toString(input).getBytes());
            }
        }
        catch (Throwable x2) {
            environment = x2;
            throw x2;
        }
        finally {
            if (outputStream != null) {
                if (environment != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)environment).addSuppressed(x2);
                    }
                } else {
                    outputStream.close();
                }
            }
        }
        int exit = process.waitFor();
        Throwable throwable = null;
        try (InputStream inputStream = process.getInputStream();){
            int ch;
            StringBuilder outBuffer = new StringBuilder();
            while ((ch = inputStream.read()) != -1) {
                outBuffer.append((char)ch);
            }
            out = outBuffer.toString();
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        try (InputStream inputStream = process.getErrorStream();){
            int ch;
            StringBuilder errBuffer = new StringBuilder();
            while ((ch = inputStream.read()) != -1) {
                errBuffer.append((char)ch);
            }
            err = errBuffer.toString();
        }
        boolean bl = global.isStrictContext();
        global.set((Object)OUT_NAME, (Object)out, bl);
        global.set((Object)ERR_NAME, (Object)err, bl);
        global.set((Object)EXIT_NAME, exit, bl);
        return out;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), ScriptingFunctions.class, name, Lookup.MH.type(rtype, types));
    }
}

