/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.dynalink.beans;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jdk.internal.dynalink.beans.ApplicableOverloadedMethods;
import jdk.internal.dynalink.beans.DynamicMethod;
import jdk.internal.dynalink.beans.OverloadedMethod;
import jdk.internal.dynalink.beans.SimpleDynamicMethod;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.support.TypeUtilities;

class OverloadedDynamicMethod
extends DynamicMethod {
    private final LinkedList<MethodHandle> methods;
    private final ClassLoader classLoader;

    OverloadedDynamicMethod(Class<?> clazz, String name) {
        this(new LinkedList<MethodHandle>(), clazz.getClassLoader(), OverloadedDynamicMethod.getClassAndMethodName(clazz, name));
    }

    private OverloadedDynamicMethod(LinkedList<MethodHandle> methods, ClassLoader classLoader, String name) {
        super(name);
        this.methods = methods;
        this.classLoader = classLoader;
    }

    @Override
    SimpleDynamicMethod getMethodForExactParamTypes(String paramTypes) {
        LinkedList<MethodHandle> matchingMethods = new LinkedList<MethodHandle>();
        for (MethodHandle method : this.methods) {
            if (!OverloadedDynamicMethod.typeMatchesDescription(paramTypes, method.type())) continue;
            matchingMethods.add(method);
        }
        switch (matchingMethods.size()) {
            case 0: {
                return null;
            }
            case 1: {
                MethodHandle target = (MethodHandle)matchingMethods.get(0);
                return new SimpleDynamicMethod(target, SimpleDynamicMethod.getMethodNameWithSignature(target, this.getName()));
            }
        }
        throw new BootstrapMethodError("Can't choose among " + matchingMethods + " for argument types " + paramTypes + " for method " + this.getName());
    }

    @Override
    public MethodHandle getInvocation(MethodType callSiteType, LinkerServices linkerServices) {
        ApplicableOverloadedMethods subtypingApplicables = this.getApplicables(callSiteType, ApplicableOverloadedMethods.APPLICABLE_BY_SUBTYPING);
        ApplicableOverloadedMethods methodInvocationApplicables = this.getApplicables(callSiteType, ApplicableOverloadedMethods.APPLICABLE_BY_METHOD_INVOCATION_CONVERSION);
        ApplicableOverloadedMethods variableArityApplicables = this.getApplicables(callSiteType, ApplicableOverloadedMethods.APPLICABLE_BY_VARIABLE_ARITY);
        List<MethodHandle> maximallySpecifics = subtypingApplicables.findMaximallySpecificMethods();
        if (maximallySpecifics.isEmpty() && (maximallySpecifics = methodInvocationApplicables.findMaximallySpecificMethods()).isEmpty()) {
            maximallySpecifics = variableArityApplicables.findMaximallySpecificMethods();
        }
        List invokables = (List)this.methods.clone();
        invokables.removeAll(subtypingApplicables.getMethods());
        invokables.removeAll(methodInvocationApplicables.getMethods());
        invokables.removeAll(variableArityApplicables.getMethods());
        Iterator it = invokables.iterator();
        while (it.hasNext()) {
            MethodHandle m = (MethodHandle)it.next();
            if (OverloadedDynamicMethod.isApplicableDynamically(linkerServices, callSiteType, m)) continue;
            it.remove();
        }
        if (invokables.isEmpty() && maximallySpecifics.size() > 1) {
            throw new BootstrapMethodError("Can't choose among " + maximallySpecifics + " for argument types " + callSiteType);
        }
        invokables.addAll(maximallySpecifics);
        switch (invokables.size()) {
            case 0: {
                return null;
            }
            case 1: {
                MethodHandle mh = (MethodHandle)invokables.iterator().next();
                return new SimpleDynamicMethod(mh).getInvocation(callSiteType, linkerServices);
            }
        }
        return new OverloadedMethod(invokables, this, callSiteType, linkerServices).getInvoker();
    }

    @Override
    public boolean contains(MethodHandle mh) {
        MethodType type = mh.type();
        for (MethodHandle method : this.methods) {
            if (!OverloadedDynamicMethod.typesEqualNoReceiver(type, method.type())) continue;
            return true;
        }
        return false;
    }

    private static boolean typesEqualNoReceiver(MethodType type1, MethodType type2) {
        int pc = type1.parameterCount();
        if (pc != type2.parameterCount()) {
            return false;
        }
        for (int i = 1; i < pc; ++i) {
            if (type1.parameterType(i) == type2.parameterType(i)) continue;
            return false;
        }
        return true;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static boolean isApplicableDynamically(LinkerServices linkerServices, MethodType callSiteType, MethodHandle m) {
        MethodType methodType = m.type();
        boolean varArgs = m.isVarargsCollector();
        int fixedArgLen = methodType.parameterCount() - (varArgs ? 1 : 0);
        int callSiteArgLen = callSiteType.parameterCount();
        if (varArgs ? callSiteArgLen < fixedArgLen : callSiteArgLen != fixedArgLen) {
            return false;
        }
        for (int i = 1; i < fixedArgLen; ++i) {
            if (OverloadedDynamicMethod.isApplicableDynamically(linkerServices, callSiteType.parameterType(i), methodType.parameterType(i))) continue;
            return false;
        }
        if (!varArgs) {
            return true;
        }
        TypeDescriptor.OfField varArgArrayType = methodType.parameterType(fixedArgLen);
        Class<?> varArgType = ((Class)varArgArrayType).getComponentType();
        if (fixedArgLen == callSiteArgLen - 1) {
            TypeDescriptor.OfField callSiteArgType = callSiteType.parameterType(fixedArgLen);
            return OverloadedDynamicMethod.isApplicableDynamically(linkerServices, callSiteArgType, varArgArrayType) || OverloadedDynamicMethod.isApplicableDynamically(linkerServices, callSiteArgType, varArgType);
        }
        for (int i = fixedArgLen; i < callSiteArgLen; ++i) {
            if (OverloadedDynamicMethod.isApplicableDynamically(linkerServices, callSiteType.parameterType(i), varArgType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isApplicableDynamically(LinkerServices linkerServices, Class<?> callSiteType, Class<?> methodType) {
        return TypeUtilities.isPotentiallyConvertible(callSiteType, methodType) || linkerServices.canConvert(callSiteType, methodType);
    }

    private ApplicableOverloadedMethods getApplicables(MethodType callSiteType, ApplicableOverloadedMethods.ApplicabilityTest test) {
        return new ApplicableOverloadedMethods(this.methods, callSiteType, test);
    }

    void addMethod(SimpleDynamicMethod method) {
        this.addMethod(method.getTarget());
    }

    public void addMethod(MethodHandle method) {
        this.methods.add(method);
    }
}

