/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import jdk.nashorn.internal.codegen.Attr;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompilationException;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.FinalizeTypes;
import jdk.nashorn.internal.codegen.FoldConstants;
import jdk.nashorn.internal.codegen.Lower;
import jdk.nashorn.internal.codegen.Splitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.debug.ASTWriter;
import jdk.nashorn.internal.ir.debug.PrintVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.Timing;

abstract class CompilationPhase
extends Enum<CompilationPhase> {
    public static final /* enum */ CompilationPhase LAZY_INITIALIZATION_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED)){

        @Override
        void transform(Compiler compiler, FunctionNode fn) {
            final FunctionNode outermostFunctionNode = compiler.getFunctionNode();
            outermostFunctionNode.setIsLazy(false);
            outermostFunctionNode.setReturnType(Type.UNKNOWN);
            final HashSet neverLazy = new HashSet();
            final HashSet lazy = new HashSet();
            outermostFunctionNode.accept(new NodeVisitor(){

                @Override
                public Node enter(CallNode node) {
                    Node callee = node.getFunction();
                    if (callee instanceof ReferenceNode) {
                        neverLazy.add(((ReferenceNode)callee).getReference());
                        return null;
                    }
                    return node;
                }

                @Override
                public Node enter(FunctionNode node) {
                    if (node == outermostFunctionNode) {
                        return node;
                    }
                    assert (Compiler.LAZY_JIT);
                    lazy.add(node);
                    return node;
                }
            });
            for (FunctionNode node : neverLazy) {
                Compiler.LOG.fine("Marking " + node.getName() + " as non lazy, as it's a self reference");
                node.setIsLazy(false);
                lazy.remove(node);
            }
            for (FunctionNode node : lazy) {
                Compiler.LOG.fine("Marking " + node.getName() + " as lazy");
                node.setIsLazy(true);
                FunctionNode parent = node.findParentFunction();
                if (parent == null) continue;
                Compiler.LOG.fine("Marking " + parent.getName() + " as having lazy children - it needs scope for all variables");
                parent.setHasLazyChildren();
            }
        }

        public String toString() {
            return "[Lazy JIT Initialization]";
        }
    };
    public static final /* enum */ CompilationPhase CONSTANT_FOLDING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED), FunctionNode.CompilationState.CONSTANT_FOLDED){

        @Override
        void transform(Compiler compiler, FunctionNode fn) {
            fn.accept(new FoldConstants());
        }

        public String toString() {
            return "[Constant Folding]";
        }
    };
    public static final /* enum */ CompilationPhase LOWERING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.CONSTANT_FOLDED), FunctionNode.CompilationState.LOWERED){

        @Override
        void transform(Compiler compiler, FunctionNode fn) {
            fn.accept(new Lower());
        }

        public String toString() {
            return "[Control Flow Lowering]";
        }
    };
    public static final /* enum */ CompilationPhase ATTRIBUTION_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED), FunctionNode.CompilationState.ATTR){

        @Override
        void transform(Compiler compiler, FunctionNode fn) {
            Context context = compiler.getContext();
            fn.accept(new Attr(context));
            if (context._print_lower_ast) {
                context.getErr().println(new ASTWriter(fn));
            }
            if (context._print_lower_parse) {
                context.getErr().println(new PrintVisitor(fn));
            }
        }

        public String toString() {
            return "[Type Attribution]";
        }
    };
    public static final /* enum */ CompilationPhase SPLITTING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.ATTR), FunctionNode.CompilationState.SPLIT){

        @Override
        void transform(Compiler compiler, FunctionNode fn) {
            CompileUnit outermostCompileUnit = compiler.addCompileUnit(compiler.firstCompileUnitName());
            new Splitter(compiler, fn, outermostCompileUnit).split();
            assert (fn.getCompileUnit() == outermostCompileUnit) : "fn.compileUnit (" + fn.getCompileUnit() + ") != " + outermostCompileUnit;
            if (fn.isStrictMode()) {
                assert (compiler.getStrictMode());
                compiler.setStrictMode(true);
            }
        }

        public String toString() {
            return "[Code Splitting]";
        }
    };
    public static final /* enum */ CompilationPhase TYPE_FINALIZATION_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.ATTR, FunctionNode.CompilationState.SPLIT), FunctionNode.CompilationState.FINALIZED){

        @Override
        void transform(Compiler compiler, FunctionNode fn) {
            fn.accept(new FinalizeTypes());
        }

        public String toString() {
            return "[Type Finalization]";
        }
    };
    public static final /* enum */ CompilationPhase BYTECODE_GENERATION_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.ATTR, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.FINALIZED}), FunctionNode.CompilationState.EMITTED){

        @Override
        void transform(Compiler compiler, FunctionNode fn) {
            Context context = compiler.getContext();
            try {
                CodeGenerator codegen = new CodeGenerator(compiler);
                fn.accept(codegen);
                codegen.generateScopeCalls();
            }
            catch (VerifyError e) {
                if (context._verify_code || context._print_code) {
                    context.getErr().println(e.getClass().getSimpleName() + ": " + e.getMessage());
                    if (context._dump_on_error) {
                        e.printStackTrace(context.getErr());
                    }
                }
                throw e;
            }
            for (CompileUnit compileUnit : compiler.getCompileUnits()) {
                String fileName;
                int index;
                ClassEmitter classEmitter = compileUnit.getClassEmitter();
                classEmitter.end();
                byte[] bytecode = classEmitter.toByteArray();
                assert (bytecode != null);
                String className = compileUnit.getUnitClassName();
                compiler.addClass(className, bytecode);
                if (context._print_code) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("class: " + className).append('\n').append(ClassEmitter.disassemble(bytecode)).append("=====");
                    context.getErr().println(sb);
                }
                if (context._verify_code) {
                    context.verify(bytecode);
                }
                if (context._dest_dir == null || !context._compile_only || (index = (fileName = className.replace('.', File.separatorChar) + ".class").lastIndexOf(File.separatorChar)) == -1) continue;
                File dir = new File(fileName.substring(0, index));
                try {
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException(dir.toString());
                    }
                    File file = new File(context._dest_dir, fileName);
                    FileOutputStream fos = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        fos.write(bytecode);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (IOException e) {
                    Compiler.LOG.warning("Skipping class dump for " + className + ": " + ECMAErrors.getMessage("io.error.cant.write", dir.toString()));
                }
            }
        }

        public String toString() {
            return "[Bytecode Generation]";
        }
    };
    private final EnumSet<FunctionNode.CompilationState> pre;
    private final FunctionNode.CompilationState post;
    private long startTime;
    private long endTime;
    private boolean isFinished;
    private static final /* synthetic */ CompilationPhase[] $VALUES;

    public static CompilationPhase[] values() {
        return (CompilationPhase[])$VALUES.clone();
    }

    public static CompilationPhase valueOf(String name) {
        return Enum.valueOf(CompilationPhase.class, name);
    }

    private CompilationPhase(EnumSet<FunctionNode.CompilationState> pre) {
        this(pre, null);
    }

    private CompilationPhase(EnumSet<FunctionNode.CompilationState> pre, FunctionNode.CompilationState post) {
        this.pre = pre;
        this.post = post;
    }

    boolean isApplicable(FunctionNode functionNode) {
        return functionNode.hasState(this.pre);
    }

    protected void begin(FunctionNode functionNode) {
        if (this.pre != null) {
            for (FunctionNode.CompilationState state : this.pre) {
                assert (functionNode.hasState(state));
            }
            for (FunctionNode.CompilationState state : FunctionNode.CompilationState.values()) {
                assert (!functionNode.hasState(state) || this.pre.contains((Object)state));
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    protected void end(FunctionNode functionNode) {
        this.endTime = System.currentTimeMillis();
        Timing.accumulateTime(this.toString(), this.endTime - this.startTime);
        if (this.post != null) {
            functionNode.setState(this.post);
        }
        this.isFinished = true;
    }

    boolean isFinished() {
        return this.isFinished;
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    abstract void transform(Compiler var1, FunctionNode var2) throws CompilationException;

    final void apply(Compiler compiler, FunctionNode functionNode) throws CompilationException {
        if (!this.isApplicable(functionNode)) {
            throw new CompilationException("compile phase not applicable: " + (Object)((Object)this));
        }
        this.begin(functionNode);
        this.transform(compiler, functionNode);
        this.end(functionNode);
    }

    static {
        $VALUES = new CompilationPhase[]{LAZY_INITIALIZATION_PHASE, CONSTANT_FOLDING_PHASE, LOWERING_PHASE, ATTRIBUTION_PHASE, SPLITTING_PHASE, TYPE_FINALIZATION_PHASE, BYTECODE_GENERATION_PHASE};
    }
}

