/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.List;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;

public class MapCreator {
    private final Class<?> structure;
    private final String[] keys;
    private final Symbol[] symbols;

    MapCreator(Class<?> structure, List<String> keys, List<Symbol> symbols) {
        int size = keys.size();
        this.structure = structure;
        this.keys = keys.toArray(new String[size]);
        this.symbols = symbols.toArray(new Symbol[size]);
    }

    PropertyMap makeMap(boolean hasArguments) {
        ArrayList<Property> properties = new ArrayList<Property>();
        assert (this.keys != null);
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            Symbol symbol = this.symbols[i];
            if (symbol == null || ArrayIndex.isIndexKey(key)) continue;
            properties.add(new AccessorProperty(key, this.getPropertyFlags(symbol, hasArguments), this.structure, symbol.getFieldIndex()));
        }
        return PropertyMap.newMap(this.structure, properties);
    }

    protected int getPropertyFlags(Symbol symbol, boolean hasArguments) {
        int flags = 0;
        if (symbol.isParam()) {
            flags |= 0xA0;
        }
        if (hasArguments) {
            flags |= 0xC0;
        }
        if (symbol.isScope()) {
            flags |= 4;
        }
        if (symbol.canBePrimitive()) {
            flags |= 0x100;
        }
        if (symbol.canBeUndefined()) {
            flags |= 0x200;
        }
        return flags;
    }
}

