/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class ObjectNode
extends Node {
    @Ignore
    private Block context;
    private final List<Node> elements;

    public ObjectNode(Source source, long token, int finish, Block context, List<Node> elements) {
        super(source, token, finish);
        this.context = context;
        this.elements = elements;
    }

    private ObjectNode(ObjectNode objectNode, Node.CopyState cs) {
        super(objectNode);
        ArrayList<Node> newElements = new ArrayList<Node>();
        for (Node element : objectNode.elements) {
            newElements.add(cs.existingOrCopy(element));
        }
        this.context = (Block)cs.existingOrCopy(objectNode.context);
        this.elements = newElements;
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new ObjectNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            if (this.context != null) {
                this.context = (Block)this.context.accept(visitor);
            }
            int count = this.elements.size();
            for (int i = 0; i < count; ++i) {
                this.elements.set(i, this.elements.get(i).accept(visitor));
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('{');
        if (!this.elements.isEmpty()) {
            sb.append(' ');
            boolean first = true;
            for (Node element : this.elements) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                element.toString(sb);
            }
            sb.append(' ');
        }
        sb.append('}');
    }

    public Block getContext() {
        return this.context;
    }

    public List<Node> getElements() {
        return Collections.unmodifiableList(this.elements);
    }
}

