/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class VarNode
extends Node
implements Assignment<IdentNode> {
    private IdentNode name;
    private Node init;
    private boolean isFunctionVarNode;

    public VarNode(Source source, long token, int finish, IdentNode name, Node init) {
        super(source, token, finish);
        this.name = name;
        this.init = init;
        if (init != null) {
            this.name.setIsInitializedHere();
        }
    }

    private VarNode(VarNode varNode, Node.CopyState cs) {
        super(varNode);
        this.name = (IdentNode)cs.existingOrCopy(varNode.name);
        this.init = cs.existingOrCopy(varNode.init);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new VarNode(this, cs);
    }

    @Override
    public boolean isAssignment() {
        return this.hasInit();
    }

    @Override
    public IdentNode getAssignmentDest() {
        return this.isAssignment() ? this.name : null;
    }

    @Override
    public void setAssignmentDest(IdentNode node) {
        this.setName(this.name);
    }

    @Override
    public Node getAssignmentSource() {
        return this.isAssignment() ? this.getInit() : null;
    }

    @Override
    public void setAssignmentSource(Node source) {
        this.setInit(source);
    }

    public boolean hasInit() {
        return this.init != null;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof VarNode) {
            VarNode otherNode = (VarNode)other;
            boolean nameMatches = this.name.equals(otherNode.name);
            if (this.hasInit() != otherNode.hasInit()) {
                return false;
            }
            if (this.init == null) {
                return nameMatches;
            }
            return nameMatches && this.init.equals(otherNode.init);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ (this.init == null ? 0 : this.init.hashCode());
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.name = (IdentNode)this.name.accept(visitor);
            if (this.init != null) {
                this.init = this.init.accept(visitor);
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("var ");
        this.name.toString(sb);
        if (this.init != null) {
            sb.append(" = ");
            this.init.toString(sb);
        }
    }

    public Node getInit() {
        return this.init;
    }

    public void setInit(Node init) {
        this.init = init;
    }

    public IdentNode getName() {
        return this.name;
    }

    public void setName(IdentNode name) {
        this.name = name;
    }

    public boolean isFunctionVarNode() {
        return this.isFunctionVarNode;
    }

    public void setIsFunctionVarNode() {
        this.isFunctionVarNode = true;
    }
}

