/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class WhileNode
extends BreakableNode {
    protected Node test;
    protected Block body;
    protected Label continueLabel;

    public WhileNode(Source source, long token, int finish) {
        super(source, token, finish);
        this.breakLabel = new Label("while_break");
        this.continueLabel = new Label("while_continue");
    }

    protected WhileNode(WhileNode whileNode, Node.CopyState cs) {
        super(whileNode);
        this.test = cs.existingOrCopy(whileNode.test);
        this.body = (Block)cs.existingOrCopy(whileNode.body);
        this.breakLabel = new Label(whileNode.breakLabel);
        this.continueLabel = new Label(whileNode.continueLabel);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new WhileNode(this, cs);
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.test = this.test.accept(visitor);
            this.body = (Block)this.body.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("while (");
        this.test.toString(sb);
        sb.append(')');
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        this.body = body;
    }

    public void setBreakLabel(Label breakLabel) {
        this.breakLabel = breakLabel;
    }

    public Label getContinueLabel() {
        return this.continueLabel;
    }

    public void setContinueLabel(Label continueLabel) {
        this.continueLabel = continueLabel;
    }

    public Node getTest() {
        return this.test;
    }

    public void setTest(Node test) {
        this.test = test;
    }
}

