/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.MethodHandleFactory;

public class AccessorProperty
extends Property {
    private static final MethodHandle REPLACE_MAP = AccessorProperty.findOwnMH("replaceMap", Object.class, Object.class, PropertyMap.class, String.class, Class.class, Class.class);
    private static final int NOOF_TYPES = ObjectClassGenerator.getNumberOfAccessorTypes();
    private MethodHandle[] getters = new MethodHandle[NOOF_TYPES];
    private static final MethodType[] ACCESSOR_GETTER_TYPES = new MethodType[NOOF_TYPES];
    private static final MethodType[] ACCESSOR_SETTER_TYPES = new MethodType[NOOF_TYPES];
    private MethodHandle primitiveGetter;
    private MethodHandle primitiveSetter;
    private MethodHandle objectGetter;
    private MethodHandle objectSetter;
    private Class<?> currentType;

    public AccessorProperty(AccessorProperty property, ScriptObject delegate) {
        this(property);
        this.getters = new MethodHandle[NOOF_TYPES];
        this.primitiveGetter = AccessorProperty.bindTo(this.primitiveGetter, delegate);
        this.primitiveSetter = AccessorProperty.bindTo(this.primitiveSetter, delegate);
        this.objectGetter = AccessorProperty.bindTo(this.objectGetter, delegate);
        this.objectSetter = AccessorProperty.bindTo(this.objectSetter, delegate);
        this.setCurrentType(property.getCurrentType());
    }

    public AccessorProperty(String key, int flags, int slot, MethodHandle getter, MethodHandle setter) {
        super(key, flags, slot);
        TypeDescriptor.OfField setterType;
        TypeDescriptor.OfField getterType = getter.type().returnType();
        TypeDescriptor.OfField ofField = setterType = setter == null ? null : setter.type().parameterType(1);
        assert (setterType == null || setterType == getterType);
        if (((Class)getterType).isPrimitive()) {
            for (int i = 0; i < NOOF_TYPES; ++i) {
                this.getters[i] = Lookup.MH.asType(Lookup.filterReturnType(getter, ObjectClassGenerator.getAccessorType(i).getTypeClass()), ACCESSOR_GETTER_TYPES[i]);
            }
        } else {
            this.objectGetter = getter;
            this.objectSetter = setter;
        }
        this.setCurrentType((Class<?>)getterType);
    }

    public AccessorProperty(String key, int flags, Class<?> structure, int slot) {
        super(key, flags, slot);
        this.primitiveGetter = null;
        this.primitiveSetter = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (this.isParameter() && this.hasArguments()) {
            MethodHandle arguments = Lookup.MH.getter(MethodHandles.lookup(), structure, "arguments", Object.class);
            MethodHandle argumentsSO = Lookup.MH.asType(arguments, arguments.type().changeReturnType(ScriptObject.class));
            this.objectGetter = Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.GET_ARGUMENT.methodHandle(), 0, argumentsSO), 1, slot);
            this.objectSetter = Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.SET_ARGUMENT.methodHandle(), 0, argumentsSO), 1, slot);
        } else {
            String fieldNameObject = ObjectClassGenerator.getFieldName(slot, Type.OBJECT);
            String fieldNamePrimitive = ObjectClassGenerator.getFieldName(slot, ObjectClassGenerator.PRIMITIVE_TYPE);
            this.objectGetter = Lookup.MH.getter(lookup, structure, fieldNameObject, Type.OBJECT.getTypeClass());
            this.objectSetter = Lookup.MH.setter(lookup, structure, fieldNameObject, Type.OBJECT.getTypeClass());
            if (!ObjectClassGenerator.OBJECT_FIELDS_ONLY) {
                this.primitiveGetter = Lookup.MH.getter(lookup, structure, fieldNamePrimitive, ObjectClassGenerator.PRIMITIVE_TYPE.getTypeClass());
                this.primitiveSetter = Lookup.MH.setter(lookup, structure, fieldNamePrimitive, ObjectClassGenerator.PRIMITIVE_TYPE.getTypeClass());
            }
        }
        Class<Object> initialType = null;
        if (ObjectClassGenerator.OBJECT_FIELDS_ONLY || this.isAlwaysObject()) {
            initialType = Object.class;
        } else if (!this.canBePrimitive()) {
            AccessorProperty.info(key + " cannot be primitive");
            initialType = Object.class;
        } else {
            AccessorProperty.info(key + " CAN be primitive");
            if (!this.canBeUndefined()) {
                AccessorProperty.info(key + " is always defined");
                initialType = Integer.TYPE;
            }
        }
        this.setCurrentType(initialType);
    }

    protected AccessorProperty(AccessorProperty property) {
        super(property);
        this.getters = property.getters;
        this.primitiveGetter = property.primitiveGetter;
        this.primitiveSetter = property.primitiveSetter;
        this.objectGetter = property.objectGetter;
        this.objectSetter = property.objectSetter;
        this.setCurrentType(property.getCurrentType());
    }

    private static MethodHandle bindTo(MethodHandle mh, Object receiver) {
        if (mh == null) {
            return null;
        }
        return Lookup.MH.dropArguments(Lookup.MH.bindTo(mh, receiver), 0, Object.class);
    }

    @Override
    protected Property copy() {
        return new AccessorProperty(this);
    }

    @Override
    public MethodHandle getGetter(Class<?> type) {
        int i = ObjectClassGenerator.getAccessorTypeIndex(type);
        if (this.getters[i] == null) {
            this.getters[i] = this.debug(Lookup.MH.asType(ObjectClassGenerator.createGetter(this.currentType, type, this.primitiveGetter, this.objectGetter), ACCESSOR_GETTER_TYPES[i]), this.currentType, type, "get");
        }
        return this.getters[i];
    }

    private Property getWiderProperty(Class<?> type) {
        AccessorProperty newProperty = new AccessorProperty(this);
        newProperty.invalidate(type);
        return newProperty;
    }

    private PropertyMap getWiderMap(PropertyMap oldMap, Property newProperty) {
        PropertyMap newMap = oldMap.replaceProperty(this, newProperty);
        assert (oldMap.size() > 0);
        assert (newMap.size() == oldMap.size());
        return newMap;
    }

    private static Object replaceMap(Object sobj, PropertyMap newMap, String key, Class<?> oldType, Class<?> newType) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            PropertyMap oldMap = ((ScriptObject)sobj).getMap();
            AccessorProperty.info("Type change for '" + key + "' " + oldType + "=>" + newType);
            AccessorProperty.finest("setting map " + sobj + " from " + Debug.id(oldMap) + " to " + Debug.id(newMap) + " " + oldMap + " => " + newMap);
        }
        ((ScriptObject)sobj).setMap(newMap);
        return sobj;
    }

    private MethodHandle generateSetter(Class<?> forType, Class<?> type) {
        MethodHandle mh = ObjectClassGenerator.createSetter(forType, type, this.primitiveSetter, this.objectSetter);
        mh = Lookup.MH.asType(mh, ACCESSOR_SETTER_TYPES[ObjectClassGenerator.getAccessorTypeIndex(type)]);
        mh = this.debug(mh, this.currentType, type, "set");
        return mh;
    }

    @Override
    public MethodHandle getSetter(Class<?> type, PropertyMap currentMap) {
        Class<?> forType;
        int i = ObjectClassGenerator.getAccessorTypeIndex(type);
        int ci = this.currentType == null ? -1 : ObjectClassGenerator.getAccessorTypeIndex(this.currentType);
        Class<?> clazz = forType = this.currentType == null ? type : this.currentType;
        if (this.needsInvalidator(i, ci)) {
            Property newProperty = this.getWiderProperty(type);
            PropertyMap newMap = this.getWiderMap(currentMap, newProperty);
            MethodHandle widerSetter = newProperty.getSetter(type, newMap);
            MethodHandle explodeTypeSetter = Lookup.MH.filterArguments(widerSetter, 0, Lookup.MH.insertArguments(REPLACE_MAP, 1, newMap, this.getKey(), this.currentType, type));
            if (this.currentType != null && this.currentType.isPrimitive() && type == Object.class) {
                return ObjectClassGenerator.createGuardBoxedPrimitiveSetter(this.currentType, this.generateSetter(this.currentType, this.currentType), explodeTypeSetter);
            }
            return explodeTypeSetter;
        }
        return this.generateSetter(forType, type);
    }

    @Override
    public boolean canChangeType() {
        if (ObjectClassGenerator.OBJECT_FIELDS_ONLY) {
            return false;
        }
        return this.currentType != Object.class && (this.isConfigurable() || this.isWritable());
    }

    private boolean needsInvalidator(int ti, int fti) {
        return this.canChangeType() && ti > fti;
    }

    private void invalidate(Class<?> newType) {
        this.getters = new MethodHandle[NOOF_TYPES];
        this.setCurrentType(newType);
    }

    private static void finest(String str) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            ObjectClassGenerator.LOG.finest(str);
        }
    }

    private static void info(String str) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            ObjectClassGenerator.LOG.info(str);
        }
    }

    private MethodHandle debug(MethodHandle mh, Class<?> forType, Class<?> type, String tag) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            MethodHandle mhd = MethodHandleFactory.addDebugPrintout(ObjectClassGenerator.LOG, mh, tag + " '" + this.getKey() + "' (property=" + Debug.id(this) + ", forType=" + MethodHandleFactory.stripName(forType) + ", type=" + MethodHandleFactory.stripName(type) + ')');
            return mhd;
        }
        return mh;
    }

    private void setCurrentType(Class<?> currentType) {
        this.currentType = currentType;
    }

    @Override
    public Class<?> getCurrentType() {
        return this.currentType;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), AccessorProperty.class, name, Lookup.MH.type(rtype, types));
    }

    static {
        for (int i = 0; i < NOOF_TYPES; ++i) {
            Type type = ObjectClassGenerator.ACCESSOR_TYPES.get(i);
            AccessorProperty.ACCESSOR_GETTER_TYPES[i] = Lookup.MH.type(type.getTypeClass(), Object.class);
            AccessorProperty.ACCESSOR_SETTER_TYPES[i] = Lookup.MH.type(Void.TYPE, Object.class, type.getTypeClass());
        }
    }
}

