/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.TimeZone;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.util.CheckClassAdapter;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Namespace;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.debug.ASTWriter;
import jdk.nashorn.internal.ir.debug.PrintVisitor;
import jdk.nashorn.internal.parser.Parser;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.NashornLoader;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptLoader;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.StructureLoader;
import jdk.nashorn.internal.runtime.Version;
import jdk.nashorn.internal.runtime.linker.JavaAdapterFactory;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.options.KeyValueOption;
import jdk.nashorn.internal.runtime.options.Option;
import jdk.nashorn.internal.runtime.options.Options;
import sun.reflect.Reflection;

public final class Context {
    public static final boolean DEBUG = Options.getBooleanProperty("nashorn.debug");
    private static final ThreadLocal<ScriptObject> currentGlobal = new ThreadLocal<ScriptObject>(){

        @Override
        protected ScriptObject initialValue() {
            return null;
        }
    };
    private final ClassLoader appLoader;
    private final ClassLoader classPathLoader;
    private final ScriptLoader scriptLoader;
    private final Namespace namespace;
    private final Options options;
    private final ErrorManager errors;
    private final PrintWriter out;
    private final PrintWriter err;
    private final Locale locale;
    final PropertyMap emptyMap = PropertyMap.newEmptyMap(this);
    public final boolean _anon_functions;
    public final int _class_cache_size;
    public final boolean _compile_only;
    public final int _callsite_flags;
    public final boolean _debug_lines;
    public final String _dest_dir;
    public final boolean _dump_on_error;
    public final boolean _early_lvalue_error;
    public final boolean _empty_statements;
    public final boolean _fullversion;
    public final boolean _loader_per_compile;
    public final boolean _no_syntax_extensions;
    public final String _package;
    public final boolean _parse_only;
    public final boolean _print_ast;
    public final boolean _print_lower_ast;
    public final boolean _print_code;
    public final boolean _print_no_newline;
    public final boolean _print_parse;
    public final boolean _print_lower_parse;
    public final boolean _print_symbols;
    public final boolean _scripting;
    public final boolean _strict;
    public final boolean _version;
    public final boolean _verify_code;
    public final TimeZone _timezone;
    private static final ClassLoader myLoader = Context.class.getClassLoader();
    private static final StructureLoader sharedLoader = AccessController.doPrivileged(new PrivilegedAction<StructureLoader>(){

        @Override
        public StructureLoader run() {
            return new StructureLoader(myLoader, null);
        }
    });

    public static ScriptObject getGlobal() {
        Class caller;
        ClassLoader callerLoader;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (callerLoader = (caller = Reflection.getCallerClass((int)2)).getClassLoader()) != myLoader && !(callerLoader instanceof StructureLoader) && !JavaAdapterFactory.isAdapterClass(caller)) {
            sm.checkPermission(new RuntimePermission("getNashornGlobal"));
        }
        return Context.getGlobalTrusted();
    }

    public static void setGlobal(ScriptObject global) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setNashornGlobal"));
        }
        if (global != null && !(global instanceof GlobalObject)) {
            throw new IllegalArgumentException("global does not implement GlobalObject!");
        }
        Context.setGlobalTrusted(global);
    }

    public static Context getContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getNashornContext"));
        }
        return Context.getContextTrusted();
    }

    public static PrintWriter getCurrentErr() {
        ScriptObject global = Context.getGlobalTrusted();
        return global != null ? global.getContext().getErr() : new PrintWriter(System.err);
    }

    public static void err(String str) {
        Context.err(str, true);
    }

    public static void err(String str, boolean crlf) {
        PrintWriter err = Context.getCurrentErr();
        if (err != null) {
            if (crlf) {
                err.println(str);
            } else {
                err.print(str);
            }
        }
    }

    public Context(Options options, ErrorManager errors, ClassLoader appLoader) {
        this(options, errors, new PrintWriter(System.out, true), new PrintWriter(System.err, true), appLoader);
    }

    public Context(Options options, ErrorManager errors, PrintWriter out, PrintWriter err, ClassLoader appLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("createNashornContext"));
        }
        this.appLoader = appLoader;
        this.scriptLoader = (ScriptLoader)AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                StructureLoader structureLoader = new StructureLoader(sharedLoader, Context.this);
                return new ScriptLoader(structureLoader, Context.this);
            }
        });
        this.namespace = new Namespace();
        this.options = options;
        this.errors = errors;
        this.locale = Locale.getDefault();
        this.out = out;
        this.err = err;
        this._anon_functions = options.getBoolean("anon.functions");
        this._class_cache_size = options.getInteger("class.cache.size");
        this._compile_only = options.getBoolean("compile.only");
        this._debug_lines = options.getBoolean("debug.lines");
        this._dest_dir = options.getString("d");
        this._dump_on_error = options.getBoolean("doe");
        this._early_lvalue_error = options.getBoolean("early.lvalue.error");
        this._empty_statements = options.getBoolean("empty.statements");
        this._fullversion = options.getBoolean("fullversion");
        this._loader_per_compile = options.getBoolean("loader.per.compile");
        this._no_syntax_extensions = options.getBoolean("no.syntax.extensions");
        this._package = options.getString("package");
        this._parse_only = options.getBoolean("parse.only");
        this._print_ast = options.getBoolean("print.ast");
        this._print_lower_ast = options.getBoolean("print.lower.ast");
        this._print_code = options.getBoolean("print.code");
        this._print_no_newline = options.getBoolean("print.no.newline");
        this._print_parse = options.getBoolean("print.parse");
        this._print_lower_parse = options.getBoolean("print.lower.parse");
        this._print_symbols = options.getBoolean("print.symbols");
        this._scripting = options.getBoolean("scripting");
        this._strict = options.getBoolean("strict");
        this._version = options.getBoolean("version");
        this._verify_code = options.getBoolean("verify.code");
        int callSiteFlags = 0;
        if (options.getBoolean("profile.callsites")) {
            callSiteFlags |= 0x10;
        }
        if (options.get("trace.callsites") instanceof KeyValueOption) {
            callSiteFlags |= 0x20;
            KeyValueOption kv = (KeyValueOption)options.get("trace.callsites");
            if (kv.hasValue("miss")) {
                callSiteFlags |= 0x40;
            }
            if (kv.hasValue("enterexit") || (callSiteFlags & 0x40) == 0) {
                callSiteFlags |= 0x80;
            }
            if (kv.hasValue("objects")) {
                callSiteFlags |= 0x100;
            }
            if (kv.hasValue("scope")) {
                callSiteFlags |= 0x200;
            }
        }
        this._callsite_flags = callSiteFlags;
        Option<?> option = options.get("timezone");
        this._timezone = option != null ? (TimeZone)option.getValue() : TimeZone.getDefault();
        String classPath = options.getString("classpath");
        if (!this._compile_only && classPath != null && !classPath.isEmpty()) {
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("createClassLoader"));
            }
            this.classPathLoader = NashornLoader.createClassLoader(classPath);
        } else {
            this.classPathLoader = null;
        }
        if (this._version) {
            this.getErr().println("nashorn " + Version.version());
        }
        if (this._fullversion) {
            this.getErr().println("nashorn full version " + Version.fullVersion());
        }
    }

    public ErrorManager getErrorManager() {
        return this.errors;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Options getOptions() {
        return this.options;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this._timezone;
    }

    public static PropertyMap getGlobalMap() {
        return Context.getGlobalTrusted().getMap();
    }

    public ScriptFunction compileScript(Source source, ScriptObject scope) {
        return this.compileScript(source, scope, this.errors);
    }

    public Object eval(ScriptObject initialScope, String string, Object callThis, Object location, boolean strict) {
        String file = location == ScriptRuntime.UNDEFINED || location == null ? "<eval>" : location.toString();
        Source source = new Source(file, string);
        boolean directEval = location != ScriptRuntime.UNDEFINED;
        ScriptObject global = Context.getGlobalTrusted();
        ScriptObject scope = initialScope;
        boolean strictFlag = directEval && strict;
        Class<?> clazz = null;
        try {
            clazz = this.compile(source, new ThrowErrorManager(), strictFlag);
        }
        catch (ParserException e) {
            e.throwAsEcmaException(global);
            return null;
        }
        if (!strictFlag) {
            try {
                strictFlag = clazz.getField(CompilerConstants.STRICT_MODE.tag()).getBoolean(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                strictFlag = false;
            }
        }
        if (strictFlag) {
            ScriptObject strictEvalScope = ((GlobalObject)((Object)global)).newObject();
            strictEvalScope.setIsScope();
            strictEvalScope.setProto(scope);
            scope = strictEvalScope;
        }
        ScriptFunction func = Context.getRunScriptFunction(clazz, scope);
        Object evalThis = directEval ? (callThis instanceof ScriptObject || strictFlag ? callThis : global) : global;
        return ScriptRuntime.apply(func, evalThis, new Object[0]);
    }

    public Object load(ScriptObject scope, Object from) throws IOException {
        ScriptObject sobj;
        Object src = from instanceof ConsString ? from.toString() : from;
        Source source = null;
        if (src instanceof String) {
            final String srcStr = (String)src;
            File file = new File(srcStr);
            if (srcStr.indexOf(58) != -1) {
                if (srcStr.startsWith("nashorn:")) {
                    final String resource = "resources/" + srcStr.substring("nashorn:".length());
                    source = AccessController.doPrivileged(new PrivilegedAction<Source>(){

                        @Override
                        public Source run() {
                            try {
                                URL resURL = Context.class.getResource(resource);
                                return resURL != null ? new Source(srcStr, resURL) : null;
                            }
                            catch (IOException exp) {
                                return null;
                            }
                        }
                    });
                } else {
                    URL url = null;
                    try {
                        url = new URL(srcStr);
                    }
                    catch (MalformedURLException e) {
                        url = file.toURI().toURL();
                    }
                    source = new Source(url.toString(), url);
                }
            } else if (file.isFile()) {
                source = new Source(srcStr, file);
            }
        } else if (src instanceof File && ((File)src).isFile()) {
            File file = (File)src;
            source = new Source(file.getName(), file);
        } else if (src instanceof URL) {
            URL url = (URL)src;
            source = new Source(url.toString(), url);
        } else if (src instanceof ScriptObject && (sobj = (ScriptObject)src).has("script") && sobj.has("name")) {
            String script = JSType.toString(sobj.get("script"));
            String name = JSType.toString(sobj.get("name"));
            source = new Source(name, script);
        }
        if (source != null) {
            return this.evaluateSource(source, scope, scope);
        }
        throw ECMAErrors.typeError("cant.load.script", ScriptRuntime.safeToString(from));
    }

    public static Class<?> forStructureClass(String fullName) throws ClassNotFoundException {
        return Class.forName(fullName, true, sharedLoader);
    }

    public Class<?> findClass(String fullName) throws ClassNotFoundException {
        SecurityManager sm;
        int index = fullName.lastIndexOf(46);
        if (index != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(fullName.substring(0, index));
        }
        if (this.classPathLoader != null) {
            try {
                return Class.forName(fullName, true, this.classPathLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(fullName, true, this.appLoader);
    }

    public static void printStackTrace(Throwable t) {
        if (DEBUG) {
            t.printStackTrace(Context.getCurrentErr());
        }
    }

    public void verify(byte[] bytecode) {
        if (this._verify_code && System.getSecurityManager() == null) {
            CheckClassAdapter.verify(new ClassReader(bytecode), this.scriptLoader, false, new PrintWriter(System.err, true));
        }
    }

    public ScriptObject createGlobal() {
        return this.initGlobal(this.newGlobal());
    }

    public ScriptObject newGlobal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("createNashornGlobal"));
        }
        return this.newGlobalTrusted();
    }

    public ScriptObject initGlobal(ScriptObject global) {
        if (!(global instanceof GlobalObject)) {
            throw new IllegalArgumentException("not a global object!");
        }
        if (!this._compile_only) {
            ScriptObject oldGlobal = Context.getGlobalTrusted();
            try {
                Context.setGlobalTrusted(global);
                ((GlobalObject)((Object)global)).initBuiltinObjects();
            }
            finally {
                Context.setGlobalTrusted(oldGlobal);
            }
        }
        return global;
    }

    static ScriptObject getGlobalTrusted() {
        return currentGlobal.get();
    }

    static void setGlobalTrusted(ScriptObject global) {
        currentGlobal.set(global);
    }

    static Context getContextTrusted() {
        return Context.getGlobalTrusted().getContext();
    }

    static Context fromClass(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        Context context = null;
        if (loader instanceof NashornLoader) {
            context = ((NashornLoader)loader).getContext();
        }
        return context != null ? context : Context.getContextTrusted();
    }

    private Object evaluateSource(Source source, ScriptObject scope, ScriptObject thiz) {
        ScriptFunction script = null;
        try {
            script = this.compileScript(source, scope, new ThrowErrorManager());
        }
        catch (ParserException e) {
            e.throwAsEcmaException();
        }
        return ScriptRuntime.apply(script, thiz, new Object[0]);
    }

    private static ScriptFunction getRunScriptFunction(Class<?> script, ScriptObject scope) {
        boolean strict;
        if (script == null) {
            return null;
        }
        MethodHandle runMethodHandle = Lookup.MH.findStatic(MethodHandles.lookup(), script, CompilerConstants.RUN_SCRIPT.tag(), Lookup.MH.type(Object.class, ScriptFunction.class, Object.class));
        try {
            strict = script.getField(CompilerConstants.STRICT_MODE.tag()).getBoolean(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            strict = false;
        }
        return ((GlobalObject)((Object)Context.getGlobalTrusted())).newScriptFunction(CompilerConstants.RUN_SCRIPT.tag(), runMethodHandle, scope, strict);
    }

    private ScriptFunction compileScript(Source source, ScriptObject scope, ErrorManager errMan) {
        return Context.getRunScriptFunction(this.compile(source, errMan, this._strict), scope);
    }

    private synchronized Class<?> compile(Source source, ErrorManager errMan, boolean strict) {
        Class<?> script;
        errMan.reset();
        GlobalObject global = null;
        if (this._class_cache_size > 0 && (script = (global = (GlobalObject)((Object)Context.getGlobalTrusted())).findCachedClass(source)) != null) {
            return script;
        }
        FunctionNode functionNode = new Parser(this, source, errMan, strict).parse();
        if (this.errors.hasErrors() || this._parse_only) {
            return null;
        }
        if (this._print_ast) {
            this.getErr().println(new ASTWriter(functionNode));
        }
        if (this._print_parse) {
            this.getErr().println(new PrintVisitor(functionNode));
        }
        URL url = source.getURL();
        ScriptLoader loader = this._loader_per_compile ? this.createNewLoader() : this.scriptLoader;
        CodeSource cs = url == null ? null : new CodeSource(url, (CodeSigner[])null);
        ContextCodeInstaller installer = new ContextCodeInstaller(this, loader, cs);
        Compiler compiler = new Compiler(installer, functionNode, strict);
        compiler.compile();
        script = compiler.install();
        if (global != null) {
            global.cacheClass(source, script);
        }
        return script;
    }

    private ScriptLoader createNewLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ScriptLoader>(){

            @Override
            public ScriptLoader run() {
                return new ScriptLoader((StructureLoader)Context.this.scriptLoader.getParent(), Context.this);
            }
        });
    }

    private ScriptObject newGlobalTrusted() {
        try {
            Class<?> clazz = Class.forName("jdk.nashorn.internal.objects.Global", true, this.scriptLoader);
            Constructor<?> cstr = clazz.getConstructor(Context.class);
            return (ScriptObject)cstr.newInstance(this);
        }
        catch (Exception e) {
            Context.printStackTrace(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static class ThrowErrorManager
    extends ErrorManager {
        @Override
        public void error(String message) {
            throw new ParserException(message);
        }

        @Override
        public void error(ParserException e) {
            throw e;
        }
    }

    public static class ContextCodeInstaller
    implements CodeInstaller<Context> {
        private final Context context;
        private final ScriptLoader loader;
        private final CodeSource codeSource;

        private ContextCodeInstaller(Context context, ScriptLoader loader, CodeSource codeSource) {
            this.context = context;
            this.loader = loader;
            this.codeSource = codeSource;
        }

        @Override
        public Context getOwner() {
            return this.context;
        }

        @Override
        public Class<?> install(String className, byte[] bytecode) {
            return this.loader.installClass(className, bytecode, this.codeSource);
        }
    }
}

