/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSErrorType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.scripts.JS$;

public final class ECMAErrors {
    private static final String MESSAGES_RESOURCE = "jdk.nashorn.internal.runtime.resources.Messages";
    private static final ResourceBundle MESSAGES_BUNDLE = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle(ECMAErrors.MESSAGES_RESOURCE, Locale.getDefault());
        }
    });
    private static final String scriptPackage;

    private ECMAErrors() {
    }

    private static ECMAException error(Object thrown, Throwable cause) {
        return new ECMAException(thrown, cause);
    }

    public static ECMAException asEcmaException(ParserException e) {
        return ECMAErrors.asEcmaException(Context.getGlobalTrusted(), e);
    }

    public static ECMAException asEcmaException(ScriptObject global, ParserException e) {
        JSErrorType errorType = e.getErrorType();
        assert (errorType != null) : "error type for " + e + " was null";
        GlobalObject globalObj = (GlobalObject)((Object)global);
        String msg = e.getMessage();
        switch (errorType) {
            case ERROR: {
                return ECMAErrors.error(globalObj.newError(msg), e);
            }
            case EVAL_ERROR: {
                return ECMAErrors.error(globalObj.newEvalError(msg), e);
            }
            case RANGE_ERROR: {
                return ECMAErrors.error(globalObj.newRangeError(msg), e);
            }
            case REFERENCE_ERROR: {
                return ECMAErrors.error(globalObj.newReferenceError(msg), e);
            }
            case SYNTAX_ERROR: {
                return ECMAErrors.error(globalObj.newSyntaxError(msg), e);
            }
            case TYPE_ERROR: {
                return ECMAErrors.error(globalObj.newTypeError(msg), e);
            }
            case URI_ERROR: {
                return ECMAErrors.error(globalObj.newURIError(msg), e);
            }
        }
        throw new AssertionError((Object)e.getMessage());
    }

    public static ECMAException syntaxError(String msgId, String ... args) {
        return ECMAErrors.syntaxError(Context.getGlobalTrusted(), msgId, args);
    }

    public static ECMAException syntaxError(ScriptObject global, String msgId, String ... args) {
        return ECMAErrors.syntaxError(global, null, msgId, args);
    }

    public static ECMAException syntaxError(Throwable cause, String msgId, String ... args) {
        return ECMAErrors.syntaxError(Context.getGlobalTrusted(), cause, msgId, args);
    }

    public static ECMAException syntaxError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("syntax.error." + msgId, args);
        return ECMAErrors.error(((GlobalObject)((Object)global)).newSyntaxError(msg), cause);
    }

    public static ECMAException typeError(String msgId, String ... args) {
        return ECMAErrors.typeError(Context.getGlobalTrusted(), msgId, args);
    }

    public static ECMAException typeError(ScriptObject global, String msgId, String ... args) {
        return ECMAErrors.typeError(global, null, msgId, args);
    }

    public static ECMAException typeError(Throwable cause, String msgId, String ... args) {
        return ECMAErrors.typeError(Context.getGlobalTrusted(), cause, msgId, args);
    }

    public static ECMAException typeError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("type.error." + msgId, args);
        return ECMAErrors.error(((GlobalObject)((Object)global)).newTypeError(msg), cause);
    }

    public static ECMAException rangeError(String msgId, String ... args) {
        return ECMAErrors.rangeError(Context.getGlobalTrusted(), msgId, args);
    }

    public static ECMAException rangeError(ScriptObject global, String msgId, String ... args) {
        return ECMAErrors.rangeError(global, null, msgId, args);
    }

    public static ECMAException rangeError(Throwable cause, String msgId, String ... args) {
        return ECMAErrors.rangeError(Context.getGlobalTrusted(), cause, msgId, args);
    }

    public static ECMAException rangeError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("range.error." + msgId, args);
        return ECMAErrors.error(((GlobalObject)((Object)global)).newRangeError(msg), cause);
    }

    public static ECMAException referenceError(String msgId, String ... args) {
        return ECMAErrors.referenceError(Context.getGlobalTrusted(), msgId, args);
    }

    public static ECMAException referenceError(ScriptObject global, String msgId, String ... args) {
        return ECMAErrors.referenceError(global, null, msgId, args);
    }

    public static ECMAException referenceError(Throwable cause, String msgId, String ... args) {
        return ECMAErrors.referenceError(Context.getGlobalTrusted(), cause, msgId, args);
    }

    public static ECMAException referenceError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("reference.error." + msgId, args);
        return ECMAErrors.error(((GlobalObject)((Object)global)).newReferenceError(msg), cause);
    }

    public static ECMAException uriError(String msgId, String ... args) {
        return ECMAErrors.uriError(Context.getGlobalTrusted(), msgId, args);
    }

    public static ECMAException uriError(ScriptObject global, String msgId, String ... args) {
        return ECMAErrors.uriError(global, null, msgId, args);
    }

    public static ECMAException uriError(Throwable cause, String msgId, String ... args) {
        return ECMAErrors.uriError(Context.getGlobalTrusted(), cause, msgId, args);
    }

    public static ECMAException uriError(ScriptObject global, Throwable cause, String msgId, String ... args) {
        String msg = ECMAErrors.getMessage("uri.error." + msgId, args);
        return ECMAErrors.error(((GlobalObject)((Object)global)).newURIError(msg), cause);
    }

    public static String getMessage(String msgId, String ... args) {
        try {
            return new MessageFormat(MESSAGES_BUNDLE.getString(msgId)).format(args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("no message resource found for message id: " + msgId);
        }
    }

    public static boolean isScriptFrame(StackTraceElement frame) {
        String className = frame.getClassName();
        if (className.startsWith(scriptPackage)) {
            String source = frame.getFileName();
            return source != null && !source.endsWith(".java") && !source.contains("nashorn:engine/resources/engine.js");
        }
        return false;
    }

    static {
        String name = JS$.class.getName();
        scriptPackage = name.substring(0, name.lastIndexOf(46));
    }
}

